/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Spaghetti3D(DensityFunction rarityModulator, DensityFunction thicknessModulator, DensityFunction.NoiseHolder noise1, DensityFunction.NoiseHolder noise2) implements DensityFunction
{
    public static final KeyDispatchDataCodec<Spaghetti3D> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("rarity").forGetter(c -> c.rarityModulator), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("thickness").forGetter(c -> c.thicknessModulator), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise1").forGetter(c -> c.noise1), (App)DensityFunction.NoiseHolder.CODEC.fieldOf("noise2").forGetter(c -> c.noise2)).apply((Applicative)instance, Spaghetti3D::new)));

    public double compute(DensityFunction.FunctionContext context) {
        double rarity = this.getRarity(this.rarityModulator.compute(context));
        double thickness = this.thicknessModulator.compute(context);
        double value1 = this.noise1.getValue((double)context.blockX() / rarity, (double)context.blockY() / rarity, (double)context.blockZ() / rarity);
        double value2 = this.noise2.getValue((double)context.blockX() / rarity, (double)context.blockY() / rarity, (double)context.blockZ() / rarity);
        return Mth.clamp((double)(Math.max(Math.abs(rarity * value1), Math.abs(rarity * value2)) - thickness), (double)-1.0, (double)1.0);
    }

    public void fillArray(double[] array, DensityFunction.ContextProvider provider) {
        provider.fillAllDirectly(array, (DensityFunction)this);
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Spaghetti3D(this.rarityModulator.mapAll(visitor), this.thicknessModulator.mapAll(visitor), visitor.visitNoise(this.noise1), visitor.visitNoise(this.noise2)));
    }

    private double getRarity(double value) {
        if (value < -0.5) {
            return 0.75;
        }
        if (value < 0.0) {
            return 1.0;
        }
        return value < 0.5 ? 1.5 : 2.0;
    }
}

