/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.density;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.dries007.tfc.world.density.Spaghetti2D;
import net.dries007.tfc.world.density.Spaghetti3D;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCDensityFunctions {
    public static final DeferredRegister<MapCodec<? extends DensityFunction>> TYPES = DeferredRegister.create((ResourceKey)Registries.DENSITY_FUNCTION_TYPE, (String)"tfc");
    public static final Id<Spaghetti2D> SPAGHETTI2D = TFCDensityFunctions.register("spaghetti2d", Spaghetti2D.CODEC);
    public static final Id<Spaghetti3D> SPAGHETTI3D = TFCDensityFunctions.register("spaghetti3d", Spaghetti3D.CODEC);
    public static final ResourceKey<DensityFunction> NOISE_CAVES = TFCDensityFunctions.key("noise_caves");
    public static final ResourceKey<DensityFunction> NOODLE_TOGGLE = TFCDensityFunctions.key("noodle_caves");
    public static final ResourceKey<DensityFunction> NOODLE_THICKNESS = TFCDensityFunctions.key("noodle_thickness");
    public static final ResourceKey<DensityFunction> NOODLE_RIDGE_A = TFCDensityFunctions.key("noodle_ridge_a");
    public static final ResourceKey<DensityFunction> NOODLE_RIDGE_B = TFCDensityFunctions.key("noodle_ridge_b");

    private static ResourceKey<DensityFunction> key(String id) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)Helpers.identifier(id));
    }

    private static <T extends DensityFunction> Id<T> register(String name, KeyDispatchDataCodec<T> codec) {
        return new Id(TYPES.register(name, () -> codec.codec()));
    }

    public record Id<T extends DensityFunction>(DeferredHolder<MapCodec<? extends DensityFunction>, MapCodec<T>> holder) implements RegistryHolder<MapCodec<? extends DensityFunction>, MapCodec<T>>
    {
    }
}

