/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.entities.misc.TFCFallingBlockEntity;
import net.dries007.tfc.common.recipes.LandslideRecipe;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.MutableDensityFunctionContext;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ErosionFeature
extends Feature<NoneFeatureConfiguration> {
    public ErosionFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        ChunkAccess chunk = level.getChunk(pos);
        ChunkPos chunkPos = new ChunkPos(pos);
        int chunkX = chunkPos.getMinBlockX();
        int chunkZ = chunkPos.getMinBlockZ();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        RockData rockData = ChunkData.get(chunk).getRockData();
        ChunkGeneratorExtension extension = (ChunkGeneratorExtension)context.chunkGenerator();
        RockLayerSettings rockSettings = extension.rockLayerSettings();
        Aquifer aquifer = extension.getOrCreateAquifer(chunk);
        MutableDensityFunctionContext point = new MutableDensityFunctionContext(mutablePos);
        int minY = context.chunkGenerator().getMinY();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int baseHeight = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, chunkX + x, chunkZ + z);
                boolean prevBlockCanLandslide = false;
                int lastSafeY = baseHeight;
                Block prevBlockHardened = null;
                mutablePos.set(chunkX + x, baseHeight, chunkZ + z);
                for (int y = baseHeight; y >= minY; --y) {
                    boolean stateAtIsFragile;
                    mutablePos.setY(y);
                    BlockState stateAt = chunk.getBlockState((BlockPos)mutablePos);
                    LandslideRecipe recipe = stateAt.isAir() ? null : LandslideRecipe.getRecipe(stateAt);
                    boolean bl = stateAtIsFragile = stateAt.isAir() || TFCFallingBlockEntity.canFallThrough((BlockGetter)level, (BlockPos)mutablePos, stateAt);
                    if (prevBlockCanLandslide) {
                        if (recipe == null) {
                            if (stateAtIsFragile) {
                                if (lastSafeY > y + 2) {
                                    mutablePos.setY(y + 1);
                                    this.setBlock(level, chunk, (BlockPos)mutablePos, rockData.getRock(chunkX + x, y + 1, chunkZ + z).hardened().defaultBlockState());
                                } else {
                                    mutablePos.setY(y + 2);
                                    boolean blockAboveIsAir = chunk.getBlockState((BlockPos)mutablePos).isAir();
                                    mutablePos.setY(y + 1);
                                    BlockState airOrLiquidState = aquifer.computeSubstance((DensityFunction.FunctionContext)point, -1.0);
                                    if (blockAboveIsAir && airOrLiquidState != null) {
                                        this.setBlock(level, chunk, (BlockPos)mutablePos, airOrLiquidState);
                                    } else {
                                        mutablePos.setY(y + 1);
                                        this.setBlock(level, chunk, (BlockPos)mutablePos, rockData.getRock(chunkX + x, y + 1, chunkZ + z).hardened().defaultBlockState());
                                    }
                                }
                            }
                            prevBlockCanLandslide = false;
                            lastSafeY = y;
                        }
                    } else if (recipe == null) {
                        lastSafeY = y;
                    } else {
                        prevBlockCanLandslide = true;
                    }
                    if (stateAtIsFragile) {
                        if (prevBlockHardened != null) {
                            mutablePos.setY(y + 1);
                            this.setBlock(level, chunk, (BlockPos)mutablePos, prevBlockHardened.defaultBlockState());
                        }
                        prevBlockHardened = null;
                        continue;
                    }
                    prevBlockHardened = rockSettings.getHardened(stateAt.getBlock());
                }
            }
        }
        return true;
    }

    private void setBlock(WorldGenLevel level, ChunkAccess chunk, BlockPos pos, BlockState state) {
        BlockState prevState = chunk.setBlockState(pos, state, false);
        if (prevState != null && prevState.hasBlockEntity()) {
            chunk.removeBlockEntity(pos);
        }
        if (state.hasPostProcess((BlockGetter)level, pos)) {
            chunk.markPosForPostprocessing(pos);
        }
    }
}

