/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.dries007.tfc.common.blocks.soil.IGrassBlock;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.world.feature.FloodFillLakeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;

public class FloodFillLakeFeature
extends Feature<FloodFillLakeConfig> {
    public FloodFillLakeFeature(Codec<FloodFillLakeConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FloodFillLakeConfig> context) {
        WorldGenLevel worldIn = context.level();
        BlockPos pos = context.origin();
        FloodFillLakeConfig config = (FloodFillLakeConfig)context.config();
        ChunkPos chunkPos = new ChunkPos(pos);
        BoundingBox box = new BoundingBox(chunkPos.getMinBlockX() - 14, Integer.MIN_VALUE, chunkPos.getMinBlockZ() - 14, chunkPos.getMaxBlockX() + 14, Integer.MAX_VALUE, chunkPos.getMaxBlockZ() + 14);
        HashSet<BlockPos> filled = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.set((Vec3i)pos);
        while (worldIn.isEmptyBlock((BlockPos)mutablePos) && mutablePos.getY() > 11) {
            mutablePos.move(0, -1, 0);
        }
        pos = mutablePos.immutable();
        BlockPos startPos = pos.above();
        BlockState fill = config.getState();
        Fluid fluid = fill.getFluidState().getType();
        if (this.floodFill(worldIn, startPos, box, filled, mutablePos, config) && filled.size() >= 20) {
            for (BlockPos filledPos : filled) {
                BlockState stateDown;
                worldIn.setBlock(filledPos, fill, 2);
                worldIn.scheduleTick(filledPos, fluid, 0);
                mutablePos.set((Vec3i)filledPos).move(0, -1, 0);
                if (filled.contains(mutablePos) || !((stateDown = worldIn.getBlockState((BlockPos)mutablePos)).getBlock() instanceof IGrassBlock)) continue;
                BlockState dirtState = ((IGrassBlock)stateDown.getBlock()).getDirt();
                worldIn.setBlock((BlockPos)mutablePos, dirtState, 2);
            }
            return true;
        }
        return false;
    }

    private boolean floodFill(WorldGenLevel worldIn, BlockPos startPos, BoundingBox box, Set<BlockPos> filled, BlockPos.MutableBlockPos mutablePos, FloodFillLakeConfig config) {
        boolean result = this.floodFillLayer(worldIn, startPos, box, filled, mutablePos, config);
        if (!result) {
            return false;
        }
        if (!config.shouldOverfill()) {
            return true;
        }
        HashSet<BlockPos> nextFilled = new HashSet<BlockPos>(filled);
        startPos = startPos.above();
        int prevSize = filled.size();
        while (this.floodFillLayer(worldIn, startPos, box, nextFilled, mutablePos, config)) {
            filled.addAll(nextFilled);
            if (prevSize == filled.size()) {
                return true;
            }
            startPos = startPos.above();
        }
        return true;
    }

    private boolean floodFillLayer(WorldGenLevel worldIn, BlockPos startPos, BoundingBox box, Set<BlockPos> filled, BlockPos.MutableBlockPos mutablePos, FloodFillLakeConfig config) {
        if (!this.isFloodFillable(worldIn.getBlockState(startPos), config)) {
            return false;
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        Direction[] directions = Direction.values();
        int maximumY = startPos.getY();
        filled.add(startPos);
        queue.addFirst(startPos);
        while (!queue.isEmpty()) {
            BlockPos posAt = (BlockPos)queue.removeFirst();
            for (Direction direction : directions) {
                BlockState stateAt;
                mutablePos.set((Vec3i)posAt).move(direction);
                if (filled.contains(mutablePos) || mutablePos.getY() > maximumY || !this.isFloodFillable(stateAt = worldIn.getBlockState((BlockPos)mutablePos), config)) continue;
                if (box.isInside((Vec3i)mutablePos)) {
                    BlockPos posNext = mutablePos.immutable();
                    queue.addFirst(posNext);
                    filled.add(posNext);
                    continue;
                }
                return false;
            }
        }
        return !filled.isEmpty();
    }

    private boolean isFloodFillable(BlockState state, FloodFillLakeConfig config) {
        return !state.isSolid() && !(state.getBlock() instanceof ILeavesBlock) && config.shouldReplace(state.getFluidState().getType());
    }
}

