/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.noise.Metaballs3D;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class PowderSnowFeature
extends Feature<BlockStateConfiguration> {
    public PowderSnowFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BlockState state = ((BlockStateConfiguration)context.config()).state;
        WorldGenLevel level = context.level();
        int size = 6 + random.nextInt(4);
        Metaballs3D noise = new Metaballs3D(Helpers.fork(random), 6, 8, -0.15f * (float)size, 0.4f * (float)size, 0.3f * (float)size);
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    BlockState foundState;
                    if (!noise.inside(x, y, z)) continue;
                    mutablePos.setWithOffset((Vec3i)pos, x, y, z);
                    if (!((float)mutablePos.getY() > 63.0f) || !Helpers.isBlock(foundState = level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.POWDER_SNOW_REPLACEABLE)) continue;
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, state);
                }
            }
        }
        return true;
    }
}

