/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.LinkedList;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class RivuletFeature
extends Feature<BlockStateConfiguration> {
    public RivuletFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        BlockStateConfiguration config = (BlockStateConfiguration)context.config();
        ChunkPos chunkPos = new ChunkPos(pos);
        BoundingBox box = new BoundingBox(chunkPos.getMinBlockX() - 14, Integer.MIN_VALUE, chunkPos.getMinBlockZ() - 14, chunkPos.getMaxBlockX() + 14, Integer.MAX_VALUE, chunkPos.getMaxBlockZ() + 14);
        HashSet<BlockPos> chosen = new HashSet<BlockPos>();
        LinkedList<BlockPos> branches = new LinkedList<BlockPos>();
        BlockPos startPos = new BlockPos(pos.getX(), world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ()), pos.getZ());
        if (!world.getFluidState(startPos.below()).isEmpty()) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        branches.add(startPos);
        boolean mainBranch = true;
        block0: while (!branches.isEmpty()) {
            BlockPos branchStartPos = (BlockPos)branches.removeFirst();
            int maxLength = 5 + rand.nextInt(8);
            if (mainBranch) {
                mainBranch = false;
                maxLength += 12;
            }
            BlockPos lastPos = branchStartPos;
            for (int i = 0; i < maxLength; ++i) {
                chosen.add(branchStartPos);
                Direction chosenDirection = null;
                int chosenHeight = 0;
                int possibleDirections = 0;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    int height;
                    mutablePos.setWithOffset((Vec3i)lastPos, direction);
                    if (!box.isInside((Vec3i)mutablePos) || !world.getFluidState(mutablePos.below()).isEmpty() || (height = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutablePos.getX(), mutablePos.getZ())) > mutablePos.getY()) continue;
                    mutablePos.setY(height - 1);
                    if (!world.getBlockState((BlockPos)mutablePos).isSolid() || chosenDirection != null && rand.nextInt(++possibleDirections) != 0) continue;
                    chosenHeight = height;
                    chosenDirection = direction;
                }
                if (possibleDirections == 0) continue block0;
                if (possibleDirections > 1 && rand.nextInt(3) == 0) {
                    branches.add(lastPos);
                }
                mutablePos.setWithOffset((Vec3i)lastPos, chosenDirection).setY(chosenHeight);
                if (chosen.contains(mutablePos) || !world.getFluidState(mutablePos.below()).isEmpty()) continue block0;
                lastPos = mutablePos.immutable();
                chosen.add(lastPos);
            }
        }
        if (!chosen.isEmpty()) {
            for (BlockPos chosenPos : chosen) {
                mutablePos.set((Vec3i)chosenPos);
                while (!FluidHelpers.isAirOrEmptyFluid(world.getBlockState((BlockPos)mutablePos))) {
                    this.setBlock((LevelWriter)world, (BlockPos)mutablePos, this.getReplaceState(world, mutablePos));
                    mutablePos.move(Direction.UP);
                }
                mutablePos.setWithOffset((Vec3i)chosenPos, Direction.DOWN);
                this.setBlock((LevelWriter)world, (BlockPos)mutablePos, this.getReplaceState(world, mutablePos));
                mutablePos.move(Direction.DOWN);
                this.setBlock((LevelWriter)world, (BlockPos)mutablePos, config.state);
                mutablePos.move(Direction.DOWN);
                this.setBlock((LevelWriter)world, (BlockPos)mutablePos, config.state);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private BlockState getReplaceState(WorldGenLevel level, BlockPos.MutableBlockPos pos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            pos.move(d);
            FluidState fluidState = level.getFluidState((BlockPos)pos);
            if (!fluidState.isEmpty()) {
                pos.move(d.getOpposite());
                return fluidState.createLegacyBlock();
            }
            pos.move(d.getOpposite());
        }
        return Blocks.AIR.defaultBlockState();
    }
}

