/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.noise.Metaballs2D;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SeaStacksFeature
extends Feature<NoneFeatureConfiguration> {
    public SeaStacksFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        RockData data = ChunkData.get((LevelReader)context.level(), pos).getRockData();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        int seaLevel = context.chunkGenerator().getSeaLevel();
        if (level.getFluidState((BlockPos)cursor).isEmpty() || pos.getY() > seaLevel) {
            return false;
        }
        BlockState rock = data.getRock((BlockPos)cursor).hardened().defaultBlockState();
        if (!Helpers.isBlock(rock, TFCTags.Blocks.SEA_STACK_ROCKS)) {
            return false;
        }
        int upOffset = Mth.nextInt((RandomSource)random, (int)2, (int)6);
        cursor.move(0, upOffset, 0);
        int radius = Mth.nextInt((RandomSource)random, (int)3, (int)6);
        this.placeStack(level, cursor.immutable(), cursor, rock, radius, Mth.nextInt((RandomSource)random, (int)5, (int)15), random, false);
        cursor.set((Vec3i)pos).move(0, upOffset - 1, 0);
        this.placeStack(level, cursor.immutable(), cursor, rock, radius / 2, upOffset, random, true);
        return true;
    }

    private void placeStack(WorldGenLevel level, BlockPos origin, BlockPos.MutableBlockPos cursor, BlockState state, int radius, int height, RandomSource random, boolean inverted) {
        ArrayList<Long> acceptedPositions = new ArrayList<Long>();
        if (inverted) {
            for (int y = -height; y <= 0; ++y) {
                this.placeStackLayerAt(level, origin, cursor, state, radius, height, random, y, acceptedPositions);
            }
        } else {
            for (int y = height - 1; y >= 0; --y) {
                this.placeStackLayerAt(level, origin, cursor, state, radius, height, random, y, acceptedPositions);
            }
        }
    }

    private void placeStackLayerAt(WorldGenLevel level, BlockPos origin, BlockPos.MutableBlockPos cursor, BlockState state, int radius, int height, RandomSource random, int y, List<Long> acceptedPositions) {
        int actualRadius = (int)((float)(radius * Mth.abs((int)(height - y))) / (float)height);
        Metaballs2D noise = Metaballs2D.simple(Helpers.fork(random), actualRadius);
        for (int x = origin.getX() - radius; x <= origin.getX() + radius; ++x) {
            for (int z = origin.getZ() - radius; z <= origin.getZ() + radius; ++z) {
                int relX = x - origin.getX();
                int relZ = z - origin.getZ();
                cursor.set(x, 0, z);
                long code = cursor.asLong();
                cursor.setY(origin.getY() + y);
                boolean inList = acceptedPositions.contains(code);
                if (!noise.inside(relX, relZ) && !inList || !level.getBlockState((BlockPos)cursor).canBeReplaced()) continue;
                this.setBlock((LevelWriter)level, (BlockPos)cursor, state);
                if (!inList) {
                    acceptedPositions.add(code);
                }
                if (actualRadius != 1 || !(random.nextFloat() < 0.4f)) continue;
                return;
            }
        }
    }
}

