/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.SoilDiscConfig;
import net.dries007.tfc.world.noise.Metaballs2D;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SoilDiscFeature
extends Feature<SoilDiscConfig> {
    public SoilDiscFeature(Codec<SoilDiscConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SoilDiscConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        SoilDiscConfig config = (SoilDiscConfig)context.config();
        boolean placed = false;
        int radius = config.getRadius(random);
        Metaballs2D noise = Metaballs2D.simple(Helpers.fork(random), radius * 2);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = pos.getX() - radius; x <= pos.getX() + radius; ++x) {
            for (int z = pos.getZ() - radius; z <= pos.getZ() + radius; ++z) {
                int relZ;
                int relX = x - pos.getX();
                if (!noise.inside(relX, relZ = z - pos.getZ())) continue;
                for (int y = pos.getY() - config.getHeight(); y <= pos.getY() + config.getHeight(); ++y) {
                    if (!(random.nextFloat() < config.integrity())) continue;
                    mutablePos.set(x, y, z);
                    BlockState stateAt = level.getBlockState((BlockPos)mutablePos);
                    BlockState stateReplacement = config.getState(stateAt);
                    if (stateReplacement == null) continue;
                    level.setBlock((BlockPos)mutablePos, stateReplacement, 2);
                    placed = true;
                }
            }
        }
        return placed;
    }
}

