/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.RockData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CaveColumnFeature
extends Feature<NoneFeatureConfiguration> {
    public CaveColumnFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState middleState;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        RockData data = ChunkData.get((LevelReader)context.level(), pos).getRockData();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        float amp = Mth.nextFloat((RandomSource)random, (float)0.25f, (float)0.6f);
        float offset = Mth.nextInt((RandomSource)random, (int)1, (int)5);
        float period = Mth.nextFloat((RandomSource)random, (float)0.4f, (float)0.6f);
        int xo = pos.getX();
        int zo = pos.getZ();
        int y = mutablePos.getY();
        mutablePos.move(0, -1, 0);
        if (!Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD)) {
            return false;
        }
        mutablePos.move(0, 1, 0);
        do {
            BlockState state = data.getRock((BlockPos)mutablePos).hardened().defaultBlockState();
            int radius = (int)(amp * Mth.sin((float)(period * (float)y + offset)) + 2.0f);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x * z * z >= radius * radius) continue;
                    mutablePos.set(xo + x, y, zo + z);
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, state);
                }
            }
            mutablePos.set(xo, ++y, zo);
        } while (Helpers.isBlock(middleState = level.getBlockState((BlockPos)mutablePos), Blocks.CAVE_AIR) || Helpers.isBlock(middleState, Blocks.LAVA));
        return true;
    }
}

