/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.dries007.tfc.world.Codecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public record ThinSpikeConfig(BlockState state, int radius, int tries, int minHeight, int maxHeight, boolean allowUnderwater) implements FeatureConfiguration
{
    public static final Codec<ThinSpikeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.BLOCK_STATE.fieldOf("state").forGetter(c -> c.state), (App)Codec.intRange((int)1, (int)16).fieldOf("radius").forGetter(c -> c.radius), (App)Codecs.POSITIVE_INT.fieldOf("tries").forGetter(c -> c.tries), (App)Codecs.POSITIVE_INT.fieldOf("min_height").forGetter(c -> c.minHeight), (App)Codecs.POSITIVE_INT.fieldOf("max_height").forGetter(c -> c.maxHeight), (App)Codec.BOOL.fieldOf("allow_underwater").forGetter(c -> c.allowUnderwater)).apply((Applicative)instance, ThinSpikeConfig::new)).comapFlatMap(c -> {
        if (c.maxHeight < c.minHeight) {
            return DataResult.error(() -> "maxHeight (" + c.minHeight + ") must be greater or equal to minHeight (" + c.maxHeight + ")");
        }
        return DataResult.success((Object)c);
    }, Function.identity());

    public int getHeight(RandomSource random) {
        if (this.minHeight == this.maxHeight) {
            return this.minHeight;
        }
        return this.minHeight + random.nextInt(this.maxHeight - this.minHeight);
    }
}

