/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.ThinSpikeBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.cave.ThinSpikeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ThinSpikeFeature
extends Feature<ThinSpikeConfig> {
    public ThinSpikeFeature(Codec<ThinSpikeConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ThinSpikeConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        ThinSpikeConfig config = (ThinSpikeConfig)context.config();
        BlockState spike = config.state();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean placedAny = false;
        for (int attempt = 0; attempt < config.tries(); ++attempt) {
            mutablePos.setWithOffset((Vec3i)pos, rand.nextInt(config.radius()) - rand.nextInt(config.radius()), rand.nextInt(config.radius() - rand.nextInt(config.radius())), rand.nextInt(config.radius()) - rand.nextInt(config.radius()));
            for (int i = 0; i < 7; ++i) {
                mutablePos.move(0, 1, 0);
                if (!ThinSpikeFeature.isEmptyBlock(config, level.getBlockState((BlockPos)mutablePos))) continue;
                mutablePos.move(0, -1, 0);
                break;
            }
            placedAny |= this.placeSpike(level, mutablePos, spike, rand, config);
        }
        return placedAny;
    }

    private boolean placeSpike(WorldGenLevel level, BlockPos.MutableBlockPos pos, BlockState spike, RandomSource random, ThinSpikeConfig config) {
        BlockState lastState;
        pos.move(0, 1, 0);
        BlockState stateAbove = level.getBlockState((BlockPos)pos);
        if (Helpers.isBlock(stateAbove, spike.getBlock()) || !config.allowUnderwater() && Helpers.isBlock(stateAbove, (TagKey<Block>)BlockTags.ICE)) {
            return false;
        }
        pos.move(0, -1, 0);
        if (!this.placeSpikeBlock(level, (BlockPos)pos, spike, config)) {
            return false;
        }
        int height = config.getHeight(random);
        for (int i = 0; i < height; ++i) {
            pos.move(0, -1, 0);
            if (this.placeSpikeBlock(level, (BlockPos)pos, spike, config)) continue;
            pos.move(0, 1, 0);
            break;
        }
        if ((lastState = level.getBlockState((BlockPos)pos)).getBlock() == spike.getBlock()) {
            lastState = (BlockState)lastState.setValue((Property)ThinSpikeBlock.TIP, (Comparable)Boolean.valueOf(true));
            level.setBlock((BlockPos)pos, lastState, 2);
            return true;
        }
        return false;
    }

    private boolean placeSpikeBlock(WorldGenLevel level, BlockPos pos, BlockState spike, ThinSpikeConfig config) {
        BlockState adjustedSpike;
        BlockState state = level.getBlockState(pos);
        if (ThinSpikeFeature.isEmptyBlock(config, state) && spike.canSurvive((LevelReader)level, pos) && (adjustedSpike = FluidHelpers.fillWithFluid(spike, state.getFluidState().getType())) != null) {
            level.setBlock(pos, adjustedSpike, 2);
            return true;
        }
        return false;
    }

    private static boolean isEmptyBlock(ThinSpikeConfig config, BlockState state) {
        return config.allowUnderwater() ? FluidHelpers.isAirOrEmptyFluid(state) : state.isAir();
    }
}

