/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.coral;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.coral.CoralWallFanBlock;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public final class CoralHelpers {
    public static boolean placeCoralBlock(LevelAccessor level, RandomSource rand, BlockPos pos, BlockState coralBlockState) {
        BlockPos abovePos = pos.above();
        BlockState blockstate = level.getBlockState(pos);
        if ((Helpers.isBlock(blockstate, (Block)TFCBlocks.SALT_WATER.get()) || Helpers.isBlock(blockstate, (TagKey<Block>)BlockTags.CORALS)) && Helpers.isBlock(level.getBlockState(abovePos), (Block)TFCBlocks.SALT_WATER.get())) {
            level.setBlock(pos, coralBlockState, 3);
            if (rand.nextFloat() < 0.25f) {
                Helpers.randomBlock(TFCTags.Blocks.SALT_WATER_CORALS, rand).ifPresent(block -> level.setBlock(abovePos, CoralHelpers.salty(block.defaultBlockState()), 2));
            } else if (rand.nextFloat() < 0.05f) {
                level.setBlock(abovePos, CoralHelpers.salty((BlockState)((Block)TFCBlocks.SEA_PICKLE.get()).defaultBlockState().setValue((Property)SeaPickleBlock.PICKLES, (Comparable)Integer.valueOf(rand.nextInt(4) + 1))), 2);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos relativePos;
                if (!(rand.nextFloat() < 0.2f) || !Helpers.isBlock(level.getBlockState(relativePos = pos.relative(direction)), (Block)TFCBlocks.SALT_WATER.get())) continue;
                Helpers.randomBlock(TFCTags.Blocks.SALT_WATER_WALL_CORALS, rand).ifPresent(block -> {
                    BlockState wallCoralState = block.defaultBlockState();
                    if (wallCoralState.hasProperty((Property)CoralWallFanBlock.FACING)) {
                        level.setBlock(relativePos, CoralHelpers.salty((BlockState)wallCoralState.setValue((Property)CoralWallFanBlock.FACING, (Comparable)direction)), 2);
                    }
                });
            }
            return true;
        }
        return false;
    }

    private static BlockState salty(BlockState state) {
        return (BlockState)state.setValue((Property)TFCBlockStateProperties.SALT_WATER, (Comparable)TFCBlockStateProperties.SALT_WATER.keyFor((Fluid)TFCFluids.SALT_WATER.getSource()));
    }
}

