/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.plant.TallWaterPlantBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.feature.BlockConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EmergentPlantFeature
extends Feature<BlockConfig<TallWaterPlantBlock>> {
    public static final Codec<BlockConfig<TallWaterPlantBlock>> CODEC = BlockConfig.codec(b -> {
        TallWaterPlantBlock t;
        return b instanceof TallWaterPlantBlock ? (t = (TallWaterPlantBlock)b) : null;
    }, "Must be a " + TallWaterPlantBlock.class.getSimpleName());

    public EmergentPlantFeature(Codec<BlockConfig<TallWaterPlantBlock>> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockConfig<TallWaterPlantBlock>> context) {
        BlockPos pos;
        WorldGenLevel level = context.level();
        Fluid fluidTop = level.getFluidState((pos = context.origin()).above()).getType();
        if (fluidTop.isSame(Fluids.EMPTY) && EnvironmentHelpers.isWorldgenReplaceable(level, pos) && EnvironmentHelpers.isWorldgenReplaceable(level, pos.above())) {
            ((TallWaterPlantBlock)((BlockConfig)context.config()).block()).placeTwoHalves((LevelAccessor)level, pos, 2, context.random());
        }
        return true;
    }
}

