/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.plant.ColumnPlantConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;

public class TFCKelpFeature
extends Feature<ColumnPlantConfig> {
    public TFCKelpFeature(Codec<ColumnPlantConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ColumnPlantConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        ColumnPlantConfig config = (ColumnPlantConfig)context.config();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int radius = config.radius();
        boolean placedAny = false;
        for (int i = 0; i < config.tries(); ++i) {
            mutablePos.setWithOffset((Vec3i)pos, rand.nextInt(radius) - rand.nextInt(radius), 0, rand.nextInt(radius) - rand.nextInt(radius));
            mutablePos.set((Vec3i)level.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR, (BlockPos)mutablePos));
            BlockState state = level.getBlockState((BlockPos)mutablePos);
            Fluid fluid = state.getFluidState().getType();
            if (fluid.getFluidType().isAir()) continue;
            BlockState bodyState = FluidHelpers.fillWithFluid(config.bodyState(), fluid);
            BlockState headState = FluidHelpers.fillWithFluid(config.headState(), fluid);
            if (bodyState == null || headState == null || !this.canPlaceBlockAt((LevelAccessor)level, (BlockPos)mutablePos, state)) continue;
            this.placeColumn((LevelAccessor)level, rand, mutablePos, Mth.nextInt((RandomSource)rand, (int)config.minHeight(), (int)config.maxHeight()), 22, 25, bodyState, headState);
            placedAny = true;
        }
        return placedAny;
    }

    private void placeColumn(LevelAccessor level, RandomSource rand, BlockPos.MutableBlockPos mutablePos, int height, int minAge, int maxAge, BlockState body, BlockState head) {
        for (int i = 1; i <= height; ++i) {
            if (this.canPlaceBlockAt(level, (BlockPos)mutablePos, body)) {
                if (i == height || !FluidHelpers.isEmptyFluid(level.getBlockState(mutablePos.above()))) {
                    if (!Helpers.isBlock(level.getBlockState(mutablePos.below()), head.getBlock())) {
                        level.setBlock((BlockPos)mutablePos, (BlockState)head.setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)rand, (int)minAge, (int)maxAge))), 16);
                    }
                    return;
                }
                level.setBlock((BlockPos)mutablePos, body, 16);
            }
            mutablePos.move(Direction.UP);
        }
    }

    private boolean canPlaceBlockAt(LevelAccessor level, BlockPos pos, BlockState state) {
        return state.canSurvive((LevelReader)level, pos) && FluidHelpers.isEmptyFluid(level.getBlockState(pos));
    }
}

