/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.plant.ColumnPlantConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class TFCTwistingVinesFeature
extends Feature<ColumnPlantConfig> {
    public static void placeColumn(LevelAccessor level, RandomSource rand, BlockPos.MutableBlockPos mutablePos, int height, int minAge, int maxAge, BlockState body, BlockState head) {
        for (int i = 1; i <= height; ++i) {
            if (EnvironmentHelpers.isWorldgenReplaceable((WorldGenLevel)level, (BlockPos)mutablePos)) {
                mutablePos.move(0, 1, 0);
                if (i == height || !level.isEmptyBlock((BlockPos)mutablePos)) {
                    mutablePos.move(0, -1, 0);
                    level.setBlock((BlockPos)mutablePos, (BlockState)head.setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)rand, (int)minAge, (int)maxAge))), 2);
                    break;
                }
                mutablePos.move(0, -1, 0);
                level.setBlock((BlockPos)mutablePos, body, 2);
            }
            mutablePos.move(0, 1, 0);
        }
    }

    public TFCTwistingVinesFeature(Codec<ColumnPlantConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ColumnPlantConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        ColumnPlantConfig config = (ColumnPlantConfig)context.config();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean placedAny = false;
        int radius = config.radius();
        for (int i = 0; i < config.tries(); ++i) {
            mutablePos.setWithOffset((Vec3i)pos, Helpers.triangle(rand, radius), 0, Helpers.triangle(rand, radius));
            mutablePos.move(0, -1, 0);
            if (!Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.GRASS_PLANTABLE_ON)) {
                return false;
            }
            mutablePos.move(0, 1, 0);
            if (!EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)mutablePos)) continue;
            TFCTwistingVinesFeature.placeColumn((LevelAccessor)level, rand, mutablePos, rand.nextInt(config.maxHeight() - config.minHeight()) + config.minHeight(), 17, 25, config.bodyState(), config.headState());
            placedAny = true;
        }
        return placedAny;
    }
}

