/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.plant.KrummholzBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.tree.KrummholzConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.neoforged.neoforge.common.Tags;

public class KrummholzFeature
extends Feature<KrummholzConfig> {
    public KrummholzFeature(Codec<KrummholzConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<KrummholzConfig> context) {
        int i;
        KrummholzConfig config = (KrummholzConfig)context.config();
        BlockState block = config.block().defaultBlockState();
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        int height = config.height().sample(context.random());
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.setWithOffset((Vec3i)pos, 0, -1, 0);
        BlockState below = level.getBlockState((BlockPos)cursor);
        boolean validBlock = Helpers.isBlock(below, TFCTags.Blocks.TREE_GROWS_ON);
        if (config.spawnsOnStone()) {
            validBlock |= Helpers.isBlock(below, (TagKey<Block>)Tags.Blocks.STONES);
        }
        if (config.spawnsOnGravel()) {
            validBlock |= Helpers.isBlock(below, (TagKey<Block>)Tags.Blocks.GRAVELS);
        }
        if (!validBlock) {
            return false;
        }
        cursor.move(0, 1, 0);
        if (!block.canSurvive((LevelReader)level, pos) || !level.getFluidState(pos).isEmpty()) {
            return false;
        }
        int maxHeight = 1;
        for (i = 0; i < height; ++i) {
            cursor.setWithOffset((Vec3i)pos, 0, i, 0);
            maxHeight = i + 1;
            if (!EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)cursor)) break;
        }
        for (i = 0; i < maxHeight; ++i) {
            BlockState newState;
            cursor.setWithOffset((Vec3i)pos, 0, i, 0);
            BlockState blockState = newState = i == maxHeight - 1 ? Helpers.setProperty(block, KrummholzBlock.TIP, true) : block;
            if (i == 0) {
                newState = Helpers.setProperty(newState, KrummholzBlock.BOTTOM, true);
            }
            level.setBlock((BlockPos)cursor, newState, 2);
        }
        return true;
    }
}

