/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.feature.tree.OverlayTreeConfig;
import net.dries007.tfc.world.feature.tree.TreeHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class OverlayTreeFeature
extends Feature<OverlayTreeConfig> {
    public OverlayTreeFeature(Codec<OverlayTreeConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<OverlayTreeConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        OverlayTreeConfig config = (OverlayTreeConfig)context.config();
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        StructureTemplateManager manager = TreeHelpers.getStructureManager(level);
        StructurePlaceSettings settings = TreeHelpers.getPlacementSettings((LevelHeightAccessor)level, chunkPos, random);
        StructureTemplate structureBase = manager.getOrCreate(config.base());
        StructureTemplate structureOverlay = manager.getOrCreate(config.overlay());
        if (TreeHelpers.isValidLocation((LevelAccessor)level, pos, settings, config.placement())) {
            boolean placeTree = config.rootSystem().map(roots -> TreeHelpers.placeRoots(level, mutablePos, roots, random) || !roots.required()).orElse(true);
            if (placeTree) {
                config.trunk().ifPresent(trunk -> {
                    int height = TreeHelpers.placeTrunk(level, (BlockPos)mutablePos, random, settings, trunk);
                    mutablePos.move(0, height, 0);
                });
                TreeHelpers.placeTemplate(structureBase, settings, (ServerLevelAccessor)level, mutablePos.subtract((Vec3i)TreeHelpers.transformCenter(structureBase.getSize(), settings)));
                settings.addProcessor((StructureProcessor)new BlockRotProcessor(config.overlayIntegrity()));
                TreeHelpers.placeTemplate(structureOverlay, settings, (ServerLevelAccessor)level, mutablePos.subtract((Vec3i)TreeHelpers.transformCenter(structureOverlay.getSize(), settings)));
                return true;
            }
            return false;
        }
        return false;
    }
}

