/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.wood.BranchDirection;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.mixin.accessor.StructureTemplateAccessor;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.feature.tree.RootConfig;
import net.dries007.tfc.world.feature.tree.TreePlacementConfig;
import net.dries007.tfc.world.feature.tree.TrunkConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public final class TreeHelpers {
    private static final Rotation[] ROTATION_VALUES = Rotation.values();
    private static final Mirror[] MIRROR_VALUES = Mirror.values();

    public static boolean isValidLocation(LevelAccessor level, BlockPos pos, StructurePlaceSettings settings, TreePlacementConfig config) {
        return TreeHelpers.isValidGround(level, pos, settings, config) && TreeHelpers.isValidTrunk(level, pos, settings, config);
    }

    public static boolean isValidGround(LevelAccessor level, BlockPos pos, StructurePlaceSettings settings, TreePlacementConfig config) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = (1 - config.width()) / 2; x <= config.width() / 2; ++x) {
            for (int z = (1 - config.width()) / 2; z <= config.width() / 2; ++z) {
                mutablePos.set(x, 0, z);
                TreeHelpers.transformMutable(mutablePos, settings.getMirror(), settings.getRotation());
                mutablePos.move((Vec3i)pos);
                if (config.groundType() == TreePlacementConfig.GroundType.FLOATING) {
                    return TreeHelpers.isValidFloatingPosition(level, mutablePos);
                }
                if (!config.mayPlaceUnderwater() ? TreeHelpers.isValidPosition(level, mutablePos, config) : TreeHelpers.isValidPositionPossiblyUnderwater(level, mutablePos, config)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isValidPosition(LevelAccessor level, BlockPos.MutableBlockPos mutablePos, TreePlacementConfig config) {
        boolean isInWater;
        BlockState stateAt = level.getBlockState((BlockPos)mutablePos);
        boolean bl = isInWater = stateAt.getFluidState().getType() == Fluids.WATER;
        if (!(config.mayPlaceInWater() && FluidHelpers.isAirOrEmptyFluid(stateAt) && isInWater || stateAt.isAir() || stateAt.getBlock() instanceof SaplingBlock)) {
            return false;
        }
        mutablePos.move(0, -1, 0);
        BlockState stateBelow = level.getBlockState((BlockPos)mutablePos);
        boolean treeGrowsOn = Helpers.isBlock(stateBelow, TFCTags.Blocks.TREE_GROWS_ON);
        if (!treeGrowsOn && config.groundType() == TreePlacementConfig.GroundType.SAND) {
            treeGrowsOn = Helpers.isBlock(stateBelow, (TagKey<Block>)BlockTags.SAND);
        }
        if (!treeGrowsOn && config.mayPlaceInWater() && isInWater) {
            treeGrowsOn = Helpers.isBlock(stateBelow, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        }
        return treeGrowsOn;
    }

    private static boolean isValidFloatingPosition(LevelAccessor level, BlockPos.MutableBlockPos mutablePos) {
        for (int i = 0; i <= 3; ++i) {
            BlockState stateAt = level.getBlockState((BlockPos)mutablePos);
            if (!EnvironmentHelpers.isWorldgenReplaceable(stateAt)) {
                return false;
            }
            mutablePos.move(0, -1, 0);
            BlockState stateBelow = level.getBlockState((BlockPos)mutablePos);
            if (!Helpers.isBlock(stateBelow, TFCTags.Blocks.BUSH_PLANTABLE_ON) && !Helpers.isBlock(stateBelow, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON) && !Helpers.isFluid(stateBelow.getFluidState(), TFCTags.Fluids.ANY_INFINITE_WATER)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidPositionPossiblyUnderwater(LevelAccessor level, BlockPos.MutableBlockPos mutablePos, TreePlacementConfig config) {
        BlockState stateAt = level.getBlockState((BlockPos)mutablePos);
        FluidState fluid = stateAt.getFluidState();
        if (fluid.getType() == TFCFluids.RIVER_WATER.get()) {
            return false;
        }
        boolean water = fluid.getType() == Fluids.WATER || !config.requiresFreshwater() && fluid.getType() == TFCFluids.SALT_WATER.getSource();
        mutablePos.move(0, -1, 0);
        BlockState stateBelow = level.getBlockState((BlockPos)mutablePos);
        if (water) {
            return Helpers.isBlock(stateBelow, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        }
        if (fluid.isEmpty()) {
            boolean treeGrowsOn = Helpers.isBlock(stateBelow, TFCTags.Blocks.TREE_GROWS_ON);
            if (!treeGrowsOn && config.groundType() == TreePlacementConfig.GroundType.SAND) {
                treeGrowsOn = Helpers.isBlock(stateBelow, (TagKey<Block>)BlockTags.SAND);
            }
            return treeGrowsOn;
        }
        return false;
    }

    public static boolean isValidTrunk(LevelAccessor level, BlockPos pos, StructurePlaceSettings settings, TreePlacementConfig config) {
        Predicate<BlockState> trunkTest = config.mayPlaceUnderwater() ? FluidHelpers::isAirOrEmptyFluid : BlockBehaviour.BlockStateBase::isAir;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = (1 - config.width()) / 2; x <= config.width() / 2; ++x) {
            for (int z = (1 - config.width()) / 2; z <= config.width() / 2; ++z) {
                for (int y = 1; y < config.height(); ++y) {
                    mutablePos.set(x, y, z);
                    TreeHelpers.transformMutable(mutablePos, settings.getMirror(), settings.getRotation());
                    mutablePos.move((Vec3i)pos);
                    BlockState stateAt = level.getBlockState((BlockPos)mutablePos);
                    if (trunkTest.test(stateAt)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void placeTemplate(StructureTemplate template, StructurePlaceSettings placementIn, ServerLevelAccessor level, BlockPos pos) {
        List transformedBlockInfos = placementIn.getRandomPalette(((StructureTemplateAccessor)template).accessor$getPalettes(), pos).blocks();
        BoundingBox boundingBox = placementIn.getBoundingBox();
        for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((ServerLevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (StructurePlaceSettings)placementIn, (List)transformedBlockInfos, (StructureTemplate)template)) {
            BlockState stateAt;
            BlockPos posAt = blockInfo.pos();
            if (boundingBox != null && !boundingBox.isInside((Vec3i)posAt) || !EnvironmentHelpers.isWorldgenReplaceable(stateAt = level.getBlockState(posAt)) && !Helpers.isBlock(stateAt.getBlock(), (TagKey<Block>)BlockTags.LEAVES)) continue;
            BlockState stateReplace = blockInfo.state().mirror(placementIn.getMirror()).rotate(placementIn.getRotation());
            level.setBlock(posAt, stateReplace, 2);
        }
    }

    public static int placeTrunk(WorldGenLevel level, BlockPos pos, RandomSource random, StructurePlaceSettings settings, TrunkConfig trunk) {
        int height = trunk.getHeight(random);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int y = 0; y < height; ++y) {
            if (trunk.wide()) {
                TreeHelpers.placeTrunk(settings, trunk, level, pos, cursor, 0, y, 0, BranchDirection.TRUNK_SOUTH_EAST);
                TreeHelpers.placeTrunk(settings, trunk, level, pos, cursor, 0, y, 1, BranchDirection.TRUNK_NORTH_EAST);
                TreeHelpers.placeTrunk(settings, trunk, level, pos, cursor, 1, y, 0, BranchDirection.TRUNK_SOUTH_WEST);
                TreeHelpers.placeTrunk(settings, trunk, level, pos, cursor, 1, y, 1, BranchDirection.TRUNK_NORTH_WEST);
                continue;
            }
            TreeHelpers.placeTrunk(settings, trunk, level, pos, cursor, 0, y, 0, BranchDirection.DOWN);
        }
        return height;
    }

    private static void placeTrunk(StructurePlaceSettings settings, TrunkConfig trunk, WorldGenLevel level, BlockPos pos, BlockPos.MutableBlockPos cursor, int x, int y, int z, BranchDirection branch) {
        cursor.set(x, y, z);
        TreeHelpers.transformMutable(cursor, settings.getMirror(), settings.getRotation());
        cursor.move((Vec3i)pos);
        BranchDirection direction = branch.mirror(settings.getMirror()).rotate(settings.getRotation());
        BlockState state = (BlockState)trunk.state().setValue(TFCBlockStateProperties.BRANCH_DIRECTION, (Comparable)((Object)direction));
        level.setBlock((BlockPos)cursor, state, 3);
    }

    public static boolean placeRoots(WorldGenLevel level, BlockPos.MutableBlockPos trunkBasePos, RootConfig config, RandomSource random) {
        if (config.specialPlacer().isPresent()) {
            return config.specialPlacer().get().placeRoots(level, random, trunkBasePos, config);
        }
        BlockPos origin = trunkBasePos.below();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        Map<Block, IWeighted<BlockState>> blocks = config.blocks();
        for (int i = 0; i < config.tries(); ++i) {
            int dx = Helpers.triangle(random, config.width());
            int dz = Helpers.triangle(random, config.width());
            int dy = -random.nextInt(config.height());
            cursor.setWithOffset((Vec3i)origin, dx, dy, dz);
            IWeighted<BlockState> weighted = blocks.get(level.getBlockState((BlockPos)cursor).getBlock());
            if (weighted == null) continue;
            level.setBlock((BlockPos)cursor, weighted.get(random), 3);
        }
        return true;
    }

    public static StructureTemplateManager getStructureManager(WorldGenLevel level) {
        return level.getLevel().getServer().getStructureManager();
    }

    public static StructurePlaceSettings getPlacementSettings(LevelHeightAccessor level, ChunkPos chunkPos, RandomSource random) {
        return new StructurePlaceSettings().setBoundingBox(new BoundingBox(chunkPos.getMinBlockX() - 16, level.getMinBuildHeight(), chunkPos.getMinBlockZ() - 16, chunkPos.getMaxBlockX() + 16, level.getMaxBuildHeight(), chunkPos.getMaxBlockZ() + 16)).setRandom(random).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR).setRotation(TreeHelpers.randomRotation(random)).setMirror(TreeHelpers.randomMirror(random));
    }

    public static void randomize(StructurePlaceSettings settings, RandomSource random) {
        settings.setRotation(TreeHelpers.randomRotation(random)).setMirror(TreeHelpers.randomMirror(random));
    }

    public static BlockPos transformCenter(Vec3i size, StructurePlaceSettings settings) {
        return TreeHelpers.transform(new BlockPos((size.getX() - 1) / 2, 0, (size.getZ() - 1) / 2), settings.getMirror(), settings.getRotation());
    }

    public static BlockPos transform(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int posX = pos.getX();
        int posZ = pos.getZ();
        boolean mirror = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                posZ = -posZ;
                break;
            }
            case FRONT_BACK: {
                posX = -posX;
                break;
            }
            default: {
                mirror = false;
            }
        }
        return switch (rotationIn) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(posZ, pos.getY(), -posX);
            case Rotation.CLOCKWISE_90 -> new BlockPos(-posZ, pos.getY(), posX);
            case Rotation.CLOCKWISE_180 -> new BlockPos(-posX, pos.getY(), -posZ);
            default -> mirror ? new BlockPos(posX, pos.getY(), posZ) : pos;
        };
    }

    public static void transformMutable(BlockPos.MutableBlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                pos.setZ(-pos.getZ());
                break;
            }
            case FRONT_BACK: {
                pos.setX(-pos.getX());
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                pos.set(pos.getZ(), pos.getY(), -pos.getX());
                break;
            }
            case CLOCKWISE_90: {
                pos.set(-pos.getZ(), pos.getY(), pos.getX());
                break;
            }
            case CLOCKWISE_180: {
                pos.set(-pos.getX(), pos.getY(), -pos.getZ());
            }
        }
    }

    private static Rotation randomRotation(RandomSource random) {
        return ROTATION_VALUES[random.nextInt(ROTATION_VALUES.length)];
    }

    private static Mirror randomMirror(RandomSource random) {
        return MIRROR_VALUES[random.nextInt(MIRROR_VALUES.length)];
    }
}

