/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.feature.vein.ClusterVeinConfig;
import net.dries007.tfc.world.feature.vein.IVein;
import net.dries007.tfc.world.feature.vein.VeinFeature;
import net.dries007.tfc.world.noise.Metaballs3D;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class ClusterVeinFeature
extends VeinFeature<ClusterVeinConfig, Vein> {
    public ClusterVeinFeature(Codec<ClusterVeinConfig> codec) {
        super(codec);
    }

    @Override
    protected float getChanceToGenerate(int x, int y, int z, Vein vein, ClusterVeinConfig config) {
        return vein.metaballs.inside(x, y, z) ? config.config().density() : 0.0f;
    }

    @Override
    protected Vein createVein(WorldGenerationContext context, int chunkX, int chunkZ, RandomSource random, ClusterVeinConfig config) {
        return new Vein(this.defaultPos(chunkX, chunkZ, random, config), Metaballs3D.simple(random, config.size()));
    }

    @Override
    protected BoundingBox getBoundingBox(ClusterVeinConfig config, Vein vein) {
        return new BoundingBox(-config.size(), -config.size(), -config.size(), config.size(), config.size(), config.size());
    }

    record Vein(BlockPos pos, Metaballs3D metaballs) implements IVein
    {
    }
}

