/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import java.util.function.Function;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.feature.vein.Indicator;
import net.dries007.tfc.world.feature.vein.VeinConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public interface IVeinConfig
extends FeatureConfiguration {
    public VeinConfig config();

    public int chunkRadius();

    public int verticalRadius();

    @Nullable
    default public Indicator indicator() {
        return this.config().indicator().orElse(null);
    }

    default public int minY() {
        return this.config().minY();
    }

    default public int maxY() {
        return this.config().maxY();
    }

    @Nullable
    default public BlockState getStateToGenerate(BlockState stoneState, RandomSource random) {
        IWeighted<BlockState> weighted = this.config().states().get(stoneState.getBlock());
        if (weighted != null) {
            return weighted.get(random);
        }
        return null;
    }

    default public boolean canSpawnAt(BlockPos pos, Function<BlockPos, Holder<Biome>> biomeQuery) {
        return this.config().biomes().map(tag -> ((Holder)biomeQuery.apply(pos)).is(tag)).orElse(true);
    }
}

