/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.vein.IVein;
import net.dries007.tfc.world.feature.vein.IVeinConfig;
import net.dries007.tfc.world.feature.vein.Indicator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class VeinFeature<C extends IVeinConfig, V extends IVein>
extends Feature<C> {
    private static final int MAX_VEIN_Y_NO_ORE_PLACED = Integer.MIN_VALUE;

    public VeinFeature(Codec<C> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<C> context) {
        ChunkPos chunkPos;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        IVeinConfig config = (IVeinConfig)context.config();
        WorldGenerationContext generationContext = new WorldGenerationContext(context.chunkGenerator(), (LevelHeightAccessor)level);
        List<V> veins = this.getNearbyVeins(level, generationContext, chunkPos = new ChunkPos(pos), config.chunkRadius(), config, p -> level.getUncachedNoiseBiome(p.getX(), p.getY(), p.getZ()));
        if (!veins.isEmpty()) {
            for (IVein vein : veins) {
                this.place(level, random, chunkPos.getMinBlockX(), chunkPos.getMinBlockZ(), vein, config);
            }
            return true;
        }
        return false;
    }

    public final List<V> getNearbyVeins(WorldGenLevel level, WorldGenerationContext context, ChunkPos pos, int radius, C config, Function<BlockPos, Holder<Biome>> biomeQuery) {
        ArrayList veins = new ArrayList();
        for (int x = pos.x - radius; x <= pos.x + radius; ++x) {
            for (int z = pos.z - radius; z <= pos.z + radius; ++z) {
                this.getVeinsAtChunk(level, context, x, z, veins, config, biomeQuery);
            }
        }
        return veins;
    }

    public final void getVeinsAtChunk(WorldGenLevel level, WorldGenerationContext context, int chunkPosX, int chunkPosZ, List<V> veins, C config, Function<BlockPos, Holder<Biome>> biomeQuery) {
        V vein;
        XoroshiroRandomSource random = new XoroshiroRandomSource(level.getSeed() ^ (long)chunkPosX * 61728364132L, config.config().seed() ^ (long)chunkPosZ * 16298364123L);
        if (random.nextInt(config.config().rarity()) == 0 && config.canSpawnAt((vein = this.createVein(context, chunkPosX << 4, chunkPosZ << 4, (RandomSource)random, config)).pos(), biomeQuery)) {
            veins.add(vein);
        }
    }

    protected void place(WorldGenLevel level, RandomSource random, int blockX, int blockZ, V vein, C config) {
        int offsetZ;
        int offsetX;
        boolean debugIndicatorLocations = false;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos pos = vein.pos();
        BoundingBox box = this.getBoundingBox(config, vein).moved(pos.getX(), pos.getY(), pos.getZ());
        if (config.config().projectOffset()) {
            XoroshiroRandomSource offsetRandom = new XoroshiroRandomSource((long)Helpers.hash(182739412341L, pos));
            offsetX = offsetRandom.nextInt(16) - offsetRandom.nextInt(16);
            offsetZ = offsetRandom.nextInt(16) - offsetRandom.nextInt(16);
        } else {
            offsetZ = 0;
            offsetX = 0;
        }
        int minX = Math.max(blockX, box.minX());
        int maxX = Math.min(blockX + 15, box.maxX());
        int minY = Math.max(config.minY(), box.minY());
        int maxY = Math.min(config.maxY(), box.maxY());
        int minZ = Math.max(blockZ, box.minZ());
        int maxZ = Math.min(blockZ + 15, box.maxZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int indicatorZ;
                int indicatorX;
                int indicatorY;
                int projectedY;
                int maxVeinY = Integer.MIN_VALUE;
                int n = projectedY = config.config().projectToSurface() ? level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, offsetX + x, offsetZ + z) : 0;
                if (config.config().nearLava() && !this.isNearLava(level, cursor, x, z)) continue;
                for (int y = minY; y <= maxY; ++y) {
                    if (!(random.nextFloat() < this.getChanceToGenerate(x - pos.getX(), y - pos.getY(), z - pos.getZ(), vein, config))) continue;
                    cursor.set(x, y + projectedY, z);
                    BlockState stoneState = level.getBlockState((BlockPos)cursor);
                    BlockState oreState = this.getStateToGenerate(stoneState, random, config, x - pos.getX(), y - pos.getY(), z - pos.getZ());
                    if (oreState == null) continue;
                    level.setBlock((BlockPos)cursor, oreState, 3);
                    maxVeinY = y + projectedY;
                }
                Indicator indicator = config.indicator();
                if (indicator == null || maxVeinY == Integer.MIN_VALUE) continue;
                if (indicator.rarity() > 0 && random.nextInt(indicator.rarity()) == 0 && Math.abs((indicatorY = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, indicatorX = x + random.nextInt(15) - random.nextInt(15), indicatorZ = z + random.nextInt(15) - random.nextInt(15))) - maxVeinY) < indicator.depth()) {
                    cursor.set(indicatorX, indicatorY, indicatorZ);
                    BlockState stateAt = level.getBlockState((BlockPos)cursor);
                    BlockState state = FluidHelpers.fillWithFluid(indicator.getStateToGenerate(random), stateAt.getFluidState().getType());
                    if (state != null && EnvironmentHelpers.isWorldgenReplaceable(stateAt) && state.canSurvive((LevelReader)level, (BlockPos)cursor)) {
                        level.setBlock((BlockPos)cursor, state, 3);
                    }
                }
                for (int i = 0; i < indicator.undergroundCount(); ++i) {
                    int indicatorZ2;
                    int maxGroundY;
                    if (indicator.undergroundRarity() != 1 && random.nextInt(indicator.undergroundRarity()) != 0) continue;
                    int indicatorX2 = x + random.nextInt(15) - random.nextInt(15);
                    indicatorY = minY + (maxY > minY ? random.nextInt(maxY - minY) : 0) + random.nextInt(32) - random.nextInt(8);
                    if (indicatorY > (maxGroundY = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, indicatorX2, indicatorZ2 = z + random.nextInt(15) - random.nextInt(15))) - 5) continue;
                    cursor.set(indicatorX2, indicatorY, indicatorZ2);
                    BlockState stateAt = level.getBlockState((BlockPos)cursor);
                    BlockState state = FluidHelpers.fillWithFluid(indicator.getStateToGenerate(random), stateAt.getFluidState().getType());
                    if (state == null || !EnvironmentHelpers.isWorldgenReplaceable(stateAt) || !state.canSurvive((LevelReader)level, (BlockPos)cursor)) continue;
                    level.setBlock((BlockPos)cursor, state, 3);
                }
            }
        }
    }

    @Nullable
    protected BlockState getStateToGenerate(BlockState stoneState, RandomSource random, C config, int x, int y, int z) {
        return config.getStateToGenerate(stoneState, random);
    }

    protected final BlockPos defaultPos(int chunkX, int chunkZ, RandomSource random, C config) {
        return new BlockPos(chunkX + random.nextInt(16), this.defaultYPos(config.verticalRadius(), random, config), chunkZ + random.nextInt(16));
    }

    protected final int defaultYPos(int verticalShrinkRange, RandomSource random, C config) {
        int actualRange = config.maxY() - config.minY() - 2 * verticalShrinkRange;
        if (actualRange > 0) {
            return config.minY() + verticalShrinkRange + random.nextInt(actualRange);
        }
        return (config.minY() + config.maxY()) / 2;
    }

    protected abstract float getChanceToGenerate(int var1, int var2, int var3, V var4, C var5);

    protected abstract V createVein(WorldGenerationContext var1, int var2, int var3, RandomSource var4, C var5);

    protected abstract BoundingBox getBoundingBox(C var1, V var2);

    private boolean isNearLava(WorldGenLevel level, BlockPos.MutableBlockPos cursor, int x, int z) {
        int lavaY = -55;
        for (int lavaX = x - 4; lavaX <= x + 4; ++lavaX) {
            for (int lavaZ = z - 4; lavaZ <= z + 4; ++lavaZ) {
                cursor.set(lavaX, -55, lavaZ);
                if (level.getFluidState((BlockPos)cursor).getType() != Fluids.LAVA) continue;
                return true;
            }
        }
        return false;
    }
}

