/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import java.util.function.IntPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.AdjacentTransformLayer;
import net.dries007.tfc.world.layer.framework.AreaContext;

public enum IceSheetEdgeLayer implements AdjacentTransformLayer
{
    INSTANCE;


    @Override
    public int apply(AreaContext context, int north, int east, int south, int west, int center) {
        Predicate<IntPredicate> matcher = p -> p.test(north) || p.test(east) || p.test(south) || p.test(west);
        if (center == TFCLayers.KNOB_AND_KETTLE || center == TFCLayers.PATTERNED_GROUND || center == TFCLayers.INVERTED_PATTERNED_GROUND || center == TFCLayers.STONE_CIRCLES) {
            if (matcher.test(i -> i == TFCLayers.ICE_SHEET_TUYAS)) {
                return TFCLayers.ICE_SHEET_TUYAS_EDGE;
            }
            if (matcher.test(TFCLayers::isFlatIceSheet)) {
                return TFCLayers.ICE_SHEET_EDGE;
            }
        }
        if (center == TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS && matcher.test(IceSheetEdgeLayer::isNotIceSheet)) {
            return TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS_EDGE;
        }
        if (center == TFCLayers.ICE_SHEET_MOUNTAINS && matcher.test(IceSheetEdgeLayer::isNotIceSheet)) {
            return TFCLayers.ICE_SHEET_MOUNTAINS_EDGE;
        }
        if (center == TFCLayers.ICE_SHEET_EDGE && matcher.test(i -> i == TFCLayers.ICE_SHEET_MOUNTAINS || i == TFCLayers.ICE_SHEET_MOUNTAINS_EDGE || i == TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS || i == TFCLayers.ICE_SHEET_OCEANIC)) {
            return TFCLayers.KNOB_AND_KETTLE;
        }
        if (center == TFCLayers.LAKE && matcher.test(TFCLayers::isFlatIceSheet) && !matcher.test(i -> i == TFCLayers.ICE_SHEET_MOUNTAINS || i == TFCLayers.ICE_SHEET_MOUNTAINS_EDGE || i == TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS || i == TFCLayers.ICE_SHEET_OCEANIC)) {
            return TFCLayers.SUBGLACIAL_LAKE;
        }
        if (TFCLayers.isFlatIceSheet(center) && matcher.test(i -> i == TFCLayers.MELTWATER_LAKE) && matcher.test(IceSheetEdgeLayer::isNotIceSheet)) {
            return TFCLayers.SUBGLACIAL_LAKE;
        }
        if (TFCLayers.isFlatIceSheet(center) && matcher.test(i -> i == TFCLayers.OCEAN || i == TFCLayers.OCEAN_REEF || i == TFCLayers.DEEP_OCEAN || i == TFCLayers.DEEP_OCEAN_TRENCH || i == TFCLayers.ICE_SHEET_SHORE)) {
            return TFCLayers.ICE_SHEET_OCEANIC;
        }
        if (IceSheetEdgeLayer.isNotIceSheetOrGlaciated(center)) {
            if (matcher.test(i -> i == TFCLayers.GLACIATED_MOUNTAINS)) {
                return TFCLayers.GLACIALLY_CARVED_MOUNTAINS;
            }
            if (matcher.test(i -> i == TFCLayers.GLACIATED_OCEANIC_MOUNTAINS)) {
                return TFCLayers.GLACIALLY_CARVED_OCEANIC_MOUNTAINS;
            }
        }
        if ((center == TFCLayers.PLATEAU || center == TFCLayers.BADLANDS || center == TFCLayers.BURREN_BADLANDS || center == TFCLayers.BURREN_BADLANDS_TALL || center == TFCLayers.GLACIATED_SHIELD_VOLCANO) && matcher.test(i -> i == TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS_EDGE)) {
            return TFCLayers.GLACIATED_OCEANIC_MOUNTAINS;
        }
        if ((center == TFCLayers.ICE_SHEET || center == TFCLayers.ICE_SHEET_TUYAS || center == TFCLayers.ICE_SHEET_SHIELD_VOLCANO) && matcher.test(i -> i == TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS_EDGE)) {
            return TFCLayers.ICE_SHEET_OCEANIC;
        }
        if (center == TFCLayers.ICE_SHEET_MOUNTAINS && matcher.test(i -> i == TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS_EDGE)) {
            return TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS;
        }
        return center;
    }

    public static boolean isNotIceSheet(int value) {
        return value != TFCLayers.ICE_SHEET && value != TFCLayers.ICE_SHEET_TUYAS && value != TFCLayers.SUBGLACIAL_LAKE && value != TFCLayers.ICE_SHEET_MOUNTAINS && value != TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS && value != TFCLayers.ICE_SHEET_SHIELD_VOLCANO;
    }

    public static boolean isNotIceSheetOrGlaciated(int value) {
        return IceSheetEdgeLayer.isNotIceSheet(value) && value != TFCLayers.GLACIATED_MOUNTAINS && value != TFCLayers.GLACIATED_OCEANIC_MOUNTAINS && value != TFCLayers.GLACIATED_SHIELD_VOLCANO;
    }
}

