/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import java.util.Random;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.layer.ForestEdgeLayer;
import net.dries007.tfc.world.layer.ForestInitLayer;
import net.dries007.tfc.world.layer.ForestRandomizeLayer;
import net.dries007.tfc.world.layer.ForestRandomizeSmallLayer;
import net.dries007.tfc.world.layer.IceSheetEdgeLayer;
import net.dries007.tfc.world.layer.MoreShoresLayer;
import net.dries007.tfc.world.layer.RegionBiomeLayer;
import net.dries007.tfc.world.layer.RegionEdgeBiomeLayer;
import net.dries007.tfc.world.layer.RegionLayer;
import net.dries007.tfc.world.layer.RegionRockLayer;
import net.dries007.tfc.world.layer.ShoreLayer;
import net.dries007.tfc.world.layer.SmoothLayer;
import net.dries007.tfc.world.layer.UniformLayer;
import net.dries007.tfc.world.layer.ZoomLayer;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.layer.framework.TypedAreaFactory;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import org.apache.commons.lang3.mutable.MutableInt;

public class TFCLayers {
    private static final BiomeExtension[] BIOME_LAYERS = new BiomeExtension[128];
    private static final MutableInt BIOME_LAYER_INDEX = new MutableInt(0);
    public static final int OCEAN = TFCLayers.idFor(TFCBiomes.OCEAN);
    public static final int OCEAN_REEF = TFCLayers.idFor(TFCBiomes.OCEAN_REEF);
    public static final int DEEP_OCEAN = TFCLayers.idFor(TFCBiomes.DEEP_OCEAN);
    public static final int DEEP_OCEAN_TRENCH = TFCLayers.idFor(TFCBiomes.DEEP_OCEAN_TRENCH);
    public static final int PLAINS = TFCLayers.idFor(TFCBiomes.PLAINS);
    public static final int HILLS = TFCLayers.idFor(TFCBiomes.HILLS);
    public static final int LOWLANDS = TFCLayers.idFor(TFCBiomes.LOWLANDS);
    public static final int SALT_MARSH = TFCLayers.idFor(TFCBiomes.SALT_MARSH);
    public static final int LOW_CANYONS = TFCLayers.idFor(TFCBiomes.LOW_CANYONS);
    public static final int ROLLING_HILLS = TFCLayers.idFor(TFCBiomes.ROLLING_HILLS);
    public static final int HIGHLANDS = TFCLayers.idFor(TFCBiomes.HIGHLANDS);
    public static final int BADLANDS = TFCLayers.idFor(TFCBiomes.BADLANDS);
    public static final int PLATEAU = TFCLayers.idFor(TFCBiomes.PLATEAU);
    public static final int PLATEAU_WIDE = TFCLayers.idFor(TFCBiomes.PLATEAU_WIDE);
    public static final int OLD_MOUNTAINS = TFCLayers.idFor(TFCBiomes.OLD_MOUNTAINS);
    public static final int MOUNTAINS = TFCLayers.idFor(TFCBiomes.MOUNTAINS);
    public static final int VOLCANIC_MOUNTAINS = TFCLayers.idFor(TFCBiomes.VOLCANIC_MOUNTAINS);
    public static final int OCEANIC_MOUNTAINS = TFCLayers.idFor(TFCBiomes.OCEANIC_MOUNTAINS);
    public static final int VOLCANIC_OCEANIC_MOUNTAINS = TFCLayers.idFor(TFCBiomes.VOLCANIC_OCEANIC_MOUNTAINS);
    public static final int CANYONS = TFCLayers.idFor(TFCBiomes.CANYONS);
    public static final int GUANO_ISLAND = TFCLayers.idFor(TFCBiomes.GUANO_ISLAND);
    public static final int SHORE = TFCLayers.idFor(TFCBiomes.SHORE);
    public static final int TIDAL_FLATS = TFCLayers.idFor(TFCBiomes.TIDAL_FLATS);
    public static final int SEA_STACKS = TFCLayers.idFor(TFCBiomes.SEA_STACKS);
    public static final int TERRACE_UPPER = TFCLayers.idFor(TFCBiomes.TERRACE_UPPER);
    public static final int TERRACE_LOWER = TFCLayers.idFor(TFCBiomes.TERRACE_LOWER);
    public static final int SETBACK_CLIFFS = TFCLayers.idFor(TFCBiomes.SETBACK_CLIFFS);
    public static final int COASTAL_DUNES = TFCLayers.idFor(TFCBiomes.COASTAL_DUNES);
    public static final int ROCKY_SHORES = TFCLayers.idFor(TFCBiomes.ROCKY_SHORES);
    public static final int EMBAYMENTS = TFCLayers.idFor(TFCBiomes.EMBAYMENTS);
    public static final int LAKE = TFCLayers.idFor(TFCBiomes.LAKE);
    public static final int RIVER = TFCLayers.idFor(TFCBiomes.RIVER);
    public static final int MOUNTAIN_LAKE = TFCLayers.idFor(TFCBiomes.MOUNTAIN_LAKE);
    public static final int VOLCANIC_MOUNTAIN_LAKE = TFCLayers.idFor(TFCBiomes.VOLCANIC_MOUNTAIN_LAKE);
    public static final int OLD_MOUNTAIN_LAKE = TFCLayers.idFor(TFCBiomes.OLD_MOUNTAIN_LAKE);
    public static final int OCEANIC_MOUNTAIN_LAKE = TFCLayers.idFor(TFCBiomes.OCEANIC_MOUNTAIN_LAKE);
    public static final int VOLCANIC_OCEANIC_MOUNTAIN_LAKE = TFCLayers.idFor(TFCBiomes.VOLCANIC_OCEANIC_MOUNTAIN_LAKE);
    public static final int PLATEAU_LAKE = TFCLayers.idFor(TFCBiomes.PLATEAU_LAKE);
    public static final int MUD_FLATS = TFCLayers.idFor(TFCBiomes.MUD_FLATS);
    public static final int SALT_FLATS = TFCLayers.idFor(TFCBiomes.SALT_FLATS);
    public static final int DUNE_SEA = TFCLayers.idFor(TFCBiomes.DUNE_SEA);
    public static final int GRASSY_DUNES = TFCLayers.idFor(TFCBiomes.GRASSY_DUNES);
    public static final int WHORLED_CANYONS = TFCLayers.idFor(TFCBiomes.WHORLED_CANYONS);
    public static final int STAIR_STEP_CANYONS = TFCLayers.idFor(TFCBiomes.STAIR_STEP_CANYONS);
    public static final int MESAS = TFCLayers.idFor(TFCBiomes.MESAS);
    public static final int BUTTES = TFCLayers.idFor(TFCBiomes.BUTTES);
    public static final int HOODOOS = TFCLayers.idFor(TFCBiomes.HOODOOS);
    public static final int ROCKY_PLATEAU = TFCLayers.idFor(TFCBiomes.ROCKY_PLATEAU);
    public static final int TOWER_KARST_PLAINS = TFCLayers.idFor(TFCBiomes.TOWER_KARST_PLAINS);
    public static final int TOWER_KARST_CANYONS = TFCLayers.idFor(TFCBiomes.TOWER_KARST_CANYONS);
    public static final int TOWER_KARST_HILLS = TFCLayers.idFor(TFCBiomes.TOWER_KARST_HILLS);
    public static final int TOWER_KARST_HIGHLANDS = TFCLayers.idFor(TFCBiomes.TOWER_KARST_HIGHLANDS);
    public static final int TOWER_KARST_LAKE = TFCLayers.idFor(TFCBiomes.TOWER_KARST_LAKE);
    public static final int TOWER_KARST_BAY = TFCLayers.idFor(TFCBiomes.TOWER_KARST_BAY);
    public static final int BURREN_PLATEAU = TFCLayers.idFor(TFCBiomes.BURREN_PLATEAU);
    public static final int BURREN_BADLANDS = TFCLayers.idFor(TFCBiomes.BURREN_BADLANDS);
    public static final int BURREN_BADLANDS_TALL = TFCLayers.idFor(TFCBiomes.BURREN_BADLANDS_TALL);
    public static final int BURREN_ROCHE_MOUTONEE = TFCLayers.idFor(TFCBiomes.BURREN_ROCHE_MOUTONEE);
    public static final int BURREN_PLAINS = TFCLayers.idFor(TFCBiomes.BURREN_PLAINS);
    public static final int SHILIN_PLAINS = TFCLayers.idFor(TFCBiomes.SHILIN_PLAINS);
    public static final int SHILIN_CANYONS = TFCLayers.idFor(TFCBiomes.SHILIN_CANYONS);
    public static final int SHILIN_HILLS = TFCLayers.idFor(TFCBiomes.SHILIN_HILLS);
    public static final int SHILIN_HIGHLANDS = TFCLayers.idFor(TFCBiomes.SHILIN_HIGHLANDS);
    public static final int SHILIN_PLATEAU = TFCLayers.idFor(TFCBiomes.SHILIN_PLATEAU);
    public static final int DOLINE_PLAINS = TFCLayers.idFor(TFCBiomes.DOLINE_PLAINS);
    public static final int DOLINE_HILLS = TFCLayers.idFor(TFCBiomes.DOLINE_HILLS);
    public static final int DOLINE_ROLLING_HILLS = TFCLayers.idFor(TFCBiomes.DOLINE_ROLLING_HILLS);
    public static final int DOLINE_HIGHLANDS = TFCLayers.idFor(TFCBiomes.DOLINE_HIGHLANDS);
    public static final int DOLINE_PLATEAU = TFCLayers.idFor(TFCBiomes.DOLINE_PLATEAU);
    public static final int DOLINE_CANYONS = TFCLayers.idFor(TFCBiomes.DOLINE_CANYONS);
    public static final int CENOTE_PLAINS = TFCLayers.idFor(TFCBiomes.CENOTE_PLAINS);
    public static final int CENOTE_HILLS = TFCLayers.idFor(TFCBiomes.CENOTE_HILLS);
    public static final int CENOTE_ROLLING_HILLS = TFCLayers.idFor(TFCBiomes.CENOTE_ROLLING_HILLS);
    public static final int CENOTE_CANYONS = TFCLayers.idFor(TFCBiomes.CENOTE_CANYONS);
    public static final int CENOTE_HIGHLANDS = TFCLayers.idFor(TFCBiomes.CENOTE_HIGHLANDS);
    public static final int CENOTE_PLATEAU = TFCLayers.idFor(TFCBiomes.CENOTE_PLATEAU);
    public static final int EXTREME_DOLINE_PLATEAU = TFCLayers.idFor(TFCBiomes.EXTREME_DOLINE_PLATEAU);
    public static final int EXTREME_DOLINE_MOUNTAINS = TFCLayers.idFor(TFCBiomes.EXTREME_DOLINE_MOUNTAINS);
    public static final int ACTIVE_SHIELD_VOLCANO = TFCLayers.idFor(TFCBiomes.ACTIVE_SHIELD_VOLCANO);
    public static final int DORMANT_SHIELD_VOLCANO = TFCLayers.idFor(TFCBiomes.DORMANT_SHIELD_VOLCANO);
    public static final int EXTINCT_SHIELD_VOLCANO = TFCLayers.idFor(TFCBiomes.EXTINCT_SHIELD_VOLCANO);
    public static final int ANCIENT_SHIELD_VOLCANO = TFCLayers.idFor(TFCBiomes.ANCIENT_SHIELD_VOLCANO);
    public static final int SUNKEN_SHIELD_VOLCANO = TFCLayers.idFor(TFCBiomes.SUNKEN_SHIELD_VOLCANO);
    public static final int SHIELD_VOLCANO_SHORE = TFCLayers.idFor(TFCBiomes.SHIELD_VOLCANO_SHORE);
    public static final int OLD_SHIELD_VOLCANO_SHORE = TFCLayers.idFor(TFCBiomes.OLD_SHIELD_VOLCANO_SHORE);
    public static final int ICE_SHEET = TFCLayers.idFor(TFCBiomes.ICE_SHEET);
    public static final int ICE_SHEET_MOUNTAINS = TFCLayers.idFor(TFCBiomes.ICE_SHEET_MOUNTAINS);
    public static final int ICE_SHEET_OCEANIC_MOUNTAINS = TFCLayers.idFor(TFCBiomes.ICE_SHEET_OCEANIC_MOUNTAINS);
    public static final int ICE_SHEET_SHIELD_VOLCANO = TFCLayers.idFor(TFCBiomes.ICE_SHEET_SHIELD_VOLCANO);
    public static final int ICE_SHEET_TUYAS = TFCLayers.idFor(TFCBiomes.ICE_SHEET_TUYAS);
    public static final int SUBGLACIAL_LAKE = TFCLayers.idFor(TFCBiomes.SUBGLACIAL_LAKE);
    public static final int ICE_SHEET_EDGE = TFCLayers.idFor(TFCBiomes.ICE_SHEET_EDGE);
    public static final int ICE_SHEET_TUYAS_EDGE = TFCLayers.idFor(TFCBiomes.ICE_SHEET_TUYAS_EDGE);
    public static final int ICE_SHEET_OCEANIC = TFCLayers.idFor(TFCBiomes.ICE_SHEET_OCEANIC);
    public static final int ICE_SHEET_OCEANIC_MOUNTAINS_EDGE = TFCLayers.idFor(TFCBiomes.ICE_SHEET_OCEANIC_MOUNTAINS_EDGE);
    public static final int ICE_SHEET_MOUNTAINS_EDGE = TFCLayers.idFor(TFCBiomes.ICE_SHEET_MOUNTAINS_EDGE);
    public static final int GLACIATED_MOUNTAINS = TFCLayers.idFor(TFCBiomes.GLACIATED_MOUNTAINS);
    public static final int GLACIATED_OCEANIC_MOUNTAINS = TFCLayers.idFor(TFCBiomes.GLACIATED_OCEANIC_MOUNTAINS);
    public static final int MELTWATER_LAKE = TFCLayers.idFor(TFCBiomes.MELTWATER_LAKE);
    public static final int GLACIATED_SHIELD_VOLCANO = TFCLayers.idFor(TFCBiomes.GLACIATED_SHIELD_VOLCANO);
    public static final int ICE_SHEET_SHORE = TFCLayers.idFor(TFCBiomes.ICE_SHEET_SHORE);
    public static final int GLACIALLY_CARVED_MOUNTAINS = TFCLayers.idFor(TFCBiomes.GLACIALLY_CARVED_MOUNTAINS);
    public static final int GLACIALLY_CARVED_OCEANIC_MOUNTAINS = TFCLayers.idFor(TFCBiomes.GLACIALLY_CARVED_OCEANIC_MOUNTAINS);
    public static final int DRUMLINS = TFCLayers.idFor(TFCBiomes.DRUMLINS);
    public static final int TUYAS = TFCLayers.idFor(TFCBiomes.TUYAS);
    public static final int KNOB_AND_KETTLE = TFCLayers.idFor(TFCBiomes.KNOB_AND_KETTLE);
    public static final int PATTERNED_GROUND = TFCLayers.idFor(TFCBiomes.PATTERNED_GROUND);
    public static final int INVERTED_PATTERNED_GROUND = TFCLayers.idFor(TFCBiomes.INVERTED_PATTERNED_GROUND);
    public static final int STONE_CIRCLES = TFCLayers.idFor(TFCBiomes.STONE_CIRCLES);

    public static BiomeExtension getFromLayerId(int id) {
        BiomeExtension v = BIOME_LAYERS[id];
        if (v == null) {
            throw new NullPointerException("Layer id = " + id + " returned null!");
        }
        return v;
    }

    public static AreaFactory createOverworldForestLayer(long seed, IArtist<AreaFactory> artist) {
        Random random = new Random(seed);
        AreaFactory layer = new ForestInitLayer(new OpenSimplex2D(random.nextInt()).spread(0.25)).apply(random.nextLong());
        artist.draw("forest", 1, layer);
        layer = ForestRandomizeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 2, layer);
        layer = ZoomLayer.FUZZY.apply(random.nextLong(), layer);
        artist.draw("forest", 3, layer);
        layer = ForestRandomizeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 4, layer);
        layer = ZoomLayer.FUZZY.apply(random.nextLong(), layer);
        artist.draw("forest", 5, layer);
        layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
        artist.draw("forest", 6, layer);
        layer = ForestEdgeLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 7, layer);
        layer = ForestRandomizeSmallLayer.INSTANCE.apply(random.nextLong(), layer);
        artist.draw("forest", 8, layer);
        for (int i = 0; i < 2; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
            artist.draw("forest", 9 + i, layer);
        }
        return layer;
    }

    public static AreaFactory createOverworldRockLayer(RegionGenerator generator, long seed) {
        Random random = new Random(seed);
        TypedAreaFactory<Region.Point> regionLayer = new RegionLayer(generator).apply(random.nextLong());
        AreaFactory layer = RegionRockLayer.INSTANCE.apply(regionLayer);
        for (int i = 0; i < 6; ++i) {
            layer = ZoomLayer.NORMAL.apply(seed, layer);
        }
        layer = SmoothLayer.INSTANCE.apply(seed, layer);
        layer = ZoomLayer.NORMAL.apply(seed, layer);
        layer = SmoothLayer.INSTANCE.apply(seed, layer);
        return layer;
    }

    public static AreaFactory createRegionBiomeLayer(RegionGenerator generator, Seed seed) {
        TypedAreaFactory<Region.Point> regionLayer = new RegionLayer(generator).apply(seed.next());
        AreaFactory mainLayer = RegionBiomeLayer.INSTANCE.apply(regionLayer);
        mainLayer = RegionEdgeBiomeLayer.INSTANCE.apply(seed.next(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(seed.next(), mainLayer);
        mainLayer = ShoreLayer.INSTANCE.apply(seed.next(), mainLayer);
        mainLayer = MoreShoresLayer.INSTANCE.apply(seed.next(), mainLayer);
        mainLayer = IceSheetEdgeLayer.INSTANCE.apply(seed.next(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(seed.next(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(seed.next(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(seed.next(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(seed.next(), mainLayer);
        mainLayer = SmoothLayer.INSTANCE.apply(seed.next(), mainLayer);
        return mainLayer;
    }

    public static AreaFactory createUniformLayer(Seed seed, int zoomLevels) {
        AreaFactory layer = UniformLayer.INSTANCE.apply(seed.next());
        for (int i = 0; i < zoomLevels; ++i) {
            layer = ZoomLayer.NORMAL.apply(seed.next(), layer);
            layer = SmoothLayer.INSTANCE.apply(seed.next(), layer);
        }
        return layer;
    }

    public static boolean hasShore(int value) {
        return value != LOW_CANYONS && value != CANYONS && value != OCEANIC_MOUNTAINS && value != VOLCANIC_OCEANIC_MOUNTAINS && value != TOWER_KARST_BAY && value != SUNKEN_SHIELD_VOLCANO && value != GLACIALLY_CARVED_OCEANIC_MOUNTAINS && value != GLACIATED_OCEANIC_MOUNTAINS && value != ICE_SHEET_OCEANIC_MOUNTAINS_EDGE && value != ICE_SHEET_SHIELD_VOLCANO && value != GLACIATED_SHIELD_VOLCANO && value != GUANO_ISLAND;
    }

    public static int shoreFor(int value) {
        if (value == LOWLANDS || value == SALT_MARSH) {
            return SALT_MARSH;
        }
        if (value == MOUNTAINS) {
            return OCEANIC_MOUNTAINS;
        }
        if (value == VOLCANIC_MOUNTAINS) {
            return VOLCANIC_OCEANIC_MOUNTAINS;
        }
        if (value == TOWER_KARST_LAKE) {
            return TOWER_KARST_BAY;
        }
        if (value == ACTIVE_SHIELD_VOLCANO) {
            return SHIELD_VOLCANO_SHORE;
        }
        if (value == DORMANT_SHIELD_VOLCANO || value == EXTINCT_SHIELD_VOLCANO || value == ANCIENT_SHIELD_VOLCANO) {
            return OLD_SHIELD_VOLCANO_SHORE;
        }
        if (TFCLayers.isFlatIceSheet(value) || value == ICE_SHEET_EDGE || value == ICE_SHEET_OCEANIC) {
            return ICE_SHEET_SHORE;
        }
        if (value == ICE_SHEET_OCEANIC_MOUNTAINS) {
            return ICE_SHEET_OCEANIC_MOUNTAINS_EDGE;
        }
        if (value == GLACIALLY_CARVED_OCEANIC_MOUNTAINS || value == GLACIALLY_CARVED_MOUNTAINS) {
            return GLACIATED_OCEANIC_MOUNTAINS;
        }
        if (value == OLD_MOUNTAINS || value == EXTREME_DOLINE_MOUNTAINS) {
            return TERRACE_LOWER;
        }
        if (value == PLATEAU || value == EXTREME_DOLINE_PLATEAU || value == BURREN_PLATEAU || value == SHILIN_PLATEAU) {
            return SEA_STACKS;
        }
        if (value == PLATEAU_WIDE || value == ROCKY_PLATEAU || value == DOLINE_PLATEAU) {
            return SETBACK_CLIFFS;
        }
        if (value == HIGHLANDS || value == CENOTE_HIGHLANDS || value == DOLINE_HIGHLANDS || value == SHILIN_HIGHLANDS || value == TOWER_KARST_HIGHLANDS) {
            return ROCKY_SHORES;
        }
        if (value == ROLLING_HILLS || value == DOLINE_ROLLING_HILLS || value == CENOTE_ROLLING_HILLS) {
            return EMBAYMENTS;
        }
        if (value == HILLS || value == CENOTE_HILLS || value == DOLINE_HILLS || value == SHILIN_HILLS || value == TOWER_KARST_HILLS || value == GRASSY_DUNES || value == DUNE_SEA) {
            return COASTAL_DUNES;
        }
        return TIDAL_FLATS;
    }

    public static boolean hasLake(int value) {
        return !TFCLayers.isOcean(value) && value != BADLANDS && value != ACTIVE_SHIELD_VOLCANO && value != DORMANT_SHIELD_VOLCANO && value != EXTINCT_SHIELD_VOLCANO && value != ANCIENT_SHIELD_VOLCANO && value != ICE_SHEET_MOUNTAINS && value != ICE_SHEET_MOUNTAINS_EDGE && value != ICE_SHEET_OCEANIC_MOUNTAINS && value != ICE_SHEET_OCEANIC_MOUNTAINS_EDGE && value != ICE_SHEET_SHIELD_VOLCANO && value != ICE_SHEET_SHORE && value != GLACIATED_SHIELD_VOLCANO && value != GLACIATED_MOUNTAINS && value != GLACIATED_OCEANIC_MOUNTAINS && value != GLACIALLY_CARVED_MOUNTAINS && value != GLACIALLY_CARVED_OCEANIC_MOUNTAINS;
    }

    public static int lakeFor(int value) {
        if (value == MOUNTAINS) {
            return MOUNTAIN_LAKE;
        }
        if (value == VOLCANIC_MOUNTAINS) {
            return VOLCANIC_MOUNTAIN_LAKE;
        }
        if (value == OLD_MOUNTAINS) {
            return OLD_MOUNTAIN_LAKE;
        }
        if (value == OCEANIC_MOUNTAINS) {
            return OCEANIC_MOUNTAIN_LAKE;
        }
        if (value == VOLCANIC_OCEANIC_MOUNTAINS) {
            return VOLCANIC_OCEANIC_MOUNTAIN_LAKE;
        }
        if (value == PLATEAU) {
            return PLATEAU_LAKE;
        }
        if (TFCLayers.isFlatIceSheet(value)) {
            return SUBGLACIAL_LAKE;
        }
        if (value == ICE_SHEET_EDGE) {
            return MELTWATER_LAKE;
        }
        return LAKE;
    }

    public static boolean isOcean(int value) {
        return value == OCEAN || value == DEEP_OCEAN || value == DEEP_OCEAN_TRENCH || value == OCEAN_REEF;
    }

    public static boolean isMountains(int value) {
        return value == MOUNTAINS || value == OCEANIC_MOUNTAINS || value == OLD_MOUNTAINS || value == VOLCANIC_MOUNTAINS || value == VOLCANIC_OCEANIC_MOUNTAINS;
    }

    public static boolean isLow(int value) {
        return value == PLAINS || value == HILLS || value == LOW_CANYONS || value == LOWLANDS || value == SALT_MARSH || value == MUD_FLATS || value == SALT_FLATS || value == DUNE_SEA;
    }

    public static boolean isFlats(int value) {
        return value == MUD_FLATS || value == SALT_FLATS;
    }

    public static boolean isFlatIceSheet(int value) {
        return value == ICE_SHEET || value == ICE_SHEET_TUYAS || value == SUBGLACIAL_LAKE;
    }

    public static int idFor(BiomeExtension extension) {
        int index = BIOME_LAYER_INDEX.getAndIncrement();
        if (index >= BIOME_LAYERS.length) {
            throw new IllegalStateException("Tried to register layer id " + index + " but only had space for " + BIOME_LAYERS.length + " layers");
        }
        TFCLayers.BIOME_LAYERS[index] = extension;
        return index;
    }
}

