/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.TransformLayer;

public enum ZoomLayer implements TransformLayer
{
    NORMAL{

        @Override
        public int choose(AreaContext context, int first, int second, int third, int fourth) {
            if (first == second) {
                return first == third || third != fourth ? first : context.choose(first, third);
            }
            if (first == third) {
                return second != fourth ? first : context.choose(first, second);
            }
            if (first == fourth) {
                return second != third ? first : context.choose(first, second);
            }
            if (second == third || second == fourth) {
                return second;
            }
            if (third == fourth) {
                return third;
            }
            return context.choose(first, second, third, fourth);
        }
    }
    ,
    FUZZY{

        @Override
        public int choose(AreaContext context, int first, int second, int third, int fourth) {
            return context.choose(first, second, third, fourth);
        }
    };


    @Override
    public int apply(AreaContext context, Area area, int x, int z) {
        int parentX = x >> 1;
        int parentZ = z >> 1;
        int offsetX = x & 1;
        int offsetZ = z & 1;
        int northWest = area.get(parentX, parentZ);
        context.setSeed(parentX, parentZ);
        if (offsetX == 0 && offsetZ == 0) {
            return northWest;
        }
        if (offsetX == 0) {
            return context.choose(northWest, area.get(parentX, parentZ + 1));
        }
        if (offsetZ == 0) {
            return context.choose(northWest, area.get(parentX + 1, parentZ));
        }
        return this.choose(context, northWest, area.get(parentX, parentZ + 1), area.get(parentX + 1, parentZ), area.get(parentX + 1, parentZ + 1));
    }

    public abstract int choose(AreaContext var1, int var2, int var3, int var4, int var5);
}

