/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import it.unimi.dsi.fastutil.HashCommon;
import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.Noise3D;

public class Cellular3D
implements Noise3D {
    private final int seed;
    private double frequency;

    public Cellular3D(long seed) {
        this.seed = HashCommon.long2int((long)seed);
        this.frequency = 1.0;
    }

    @Override
    public double noise(double x, double y, double z) {
        return this.cell(x, y, z).noise();
    }

    @Override
    public Cellular3D spread(double scaleFactor) {
        this.frequency *= scaleFactor;
        return this;
    }

    public Cell cell(double x, double y, double z) {
        int xr = FastNoiseLite.FastRound(x *= this.frequency);
        int yr = FastNoiseLite.FastRound(y *= this.frequency);
        int zr = FastNoiseLite.FastRound(z *= this.frequency);
        double distance0 = Double.MAX_VALUE;
        double distance1 = Double.MAX_VALUE;
        int closestHash = 0;
        double closestCenterX = 0.0;
        double closestCenterY = 0.0;
        double closestCenterZ = 0.0;
        double cellularJitter = 0.39614352583885193;
        int xPrimed = (xr - 1) * 501125321;
        int yPrimedBase = (yr - 1) * 1136930381;
        int zPrimedBase = (zr - 1) * 1720413743;
        for (int xi = xr - 1; xi <= xr + 1; ++xi) {
            int yPrimed = yPrimedBase;
            for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                int zPrimed = zPrimedBase;
                for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                    int hash = FastNoiseLite.Hash(this.seed, xPrimed, yPrimed, zPrimed);
                    int idx = hash & 0x3FC;
                    double vecX = (double)xi + (double)FastNoiseLite.RandVecs3D[idx] * cellularJitter;
                    double vecY = (double)yi + (double)FastNoiseLite.RandVecs3D[idx | 1] * cellularJitter;
                    double vecZ = (double)zi + (double)FastNoiseLite.RandVecs3D[idx | 2] * cellularJitter;
                    double newDistance = (vecX - x) * (vecX - x) + (vecY - y) * (vecY - y) + (vecZ - z) * (vecZ - z);
                    distance1 = FastNoiseLite.FastMax(FastNoiseLite.FastMin(distance1, newDistance), distance0);
                    if (newDistance < distance0) {
                        distance0 = newDistance;
                        closestHash = hash;
                        closestCenterX = vecX;
                        closestCenterY = vecY;
                        closestCenterZ = vecZ;
                    }
                    zPrimed += 1720413743;
                }
                yPrimed += 1136930381;
            }
            xPrimed += 501125321;
        }
        return new Cell(closestCenterX / this.frequency, closestCenterY / this.frequency, closestCenterZ / this.frequency, distance0, distance1, (float)closestHash * 4.656613E-10f);
    }

    public record Cell(double x, double y, double z, double f1, double f2, double noise) {
    }
}

