/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.OpenSimplex3D;

@FunctionalInterface
public interface Noise3D {
    public double noise(double var1, double var3, double var5);

    default public Noise3D octaves(int octaves) {
        double[] frequency = new double[octaves];
        double[] amplitude = new double[octaves];
        for (int i = 0; i < octaves; ++i) {
            frequency[i] = 1 << i;
            amplitude[i] = Math.pow(0.5, octaves - i);
        }
        return (x, y, z) -> {
            double value = 0.0;
            for (int i = 0; i < octaves; ++i) {
                value += this.noise(x / frequency[i], y / frequency[i], z / frequency[i]) * amplitude[i];
            }
            return value;
        };
    }

    default public Noise3D spread(double scaleFactor) {
        return (x, y, z) -> this.noise(x * scaleFactor, y * scaleFactor, z * scaleFactor);
    }

    default public Noise3D scaled(double min, double max) {
        return this.scaled(-1.0, 1.0, min, max);
    }

    default public Noise3D scaled(double oldMin, double oldMax, double min, double max) {
        return (x, y, z) -> {
            double value = this.noise(x, y, z);
            return (value - oldMin) / (oldMax - oldMin) * (max - min) + min;
        };
    }

    default public Noise3D warped(OpenSimplex3D warp) {
        warp.fnl.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        warp.fnl.SetFractalType(FastNoiseLite.FractalType.DomainWarpIndependent);
        warp.fnl.SetDomainWarpAmp(warp.getAmplitude() * 2.0);
        FastNoiseLite.Vector3 cursor = new FastNoiseLite.Vector3(0.0, 0.0, 0.0);
        return (x, y, z) -> {
            cursor.x = x;
            cursor.y = y;
            cursor.z = z;
            warp.fnl.DomainWarp(cursor);
            return this.noise(cursor.x, cursor.y, cursor.z);
        };
    }
}

