/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.Noise3D;

public class OpenSimplex3D
implements Noise3D {
    final FastNoiseLite fnl;
    private double frequency;
    private double midpoint;
    private double amplitude;

    public OpenSimplex3D(long seed) {
        this((int)(seed ^ seed >> 32));
    }

    public OpenSimplex3D(int seed) {
        this.fnl = new FastNoiseLite(seed);
        this.fnl.SetFrequency(1.0);
        this.fnl.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        this.fnl.SetFractalOctaves(1);
        this.fnl.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        this.frequency = 1.0;
        this.midpoint = 0.0;
        this.amplitude = 1.0;
    }

    @Override
    public double noise(double x, double y, double z) {
        return this.midpoint + (double)this.fnl.GetNoise(x, y, z) * this.amplitude;
    }

    @Override
    public OpenSimplex3D octaves(int octaves) {
        this.fnl.SetFractalOctaves(octaves);
        this.fnl.SetFractalType(FastNoiseLite.FractalType.FBm);
        return this.spread(1.0f / (float)(1 << octaves - 1));
    }

    @Override
    public OpenSimplex3D spread(double scaleFactor) {
        this.frequency *= scaleFactor;
        this.fnl.SetFrequency(this.frequency);
        return this;
    }

    @Override
    public OpenSimplex3D scaled(double min, double max) {
        return this.scaled(-1.0, 1.0, min, max);
    }

    @Override
    public OpenSimplex3D scaled(double oldMin, double oldMax, double min, double max) {
        assert (oldMin == -1.0 && oldMax == 1.0);
        this.midpoint = (max + min) / 2.0;
        this.amplitude = (max - min) / 2.0;
        return this;
    }

    double getAmplitude() {
        return this.amplitude;
    }
}

