/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.dries007.tfc.world.noise.TrilinearInterpolator;
import net.minecraft.world.level.levelgen.DensityFunction;

public record TrilinearInterpolatorList(ChunkNoiseSamplingSettings settings, List<TrilinearInterpolator> interpolators) {
    public static TrilinearInterpolatorList create(ChunkNoiseSamplingSettings settings) {
        return new TrilinearInterpolatorList(settings, new ArrayList<TrilinearInterpolator>());
    }

    public TrilinearInterpolator add(DensityFunction function) {
        TrilinearInterpolator interpolator = new TrilinearInterpolator(this.settings, function);
        this.interpolators.add(interpolator);
        return interpolator;
    }

    public void initializeForFirstCellX() {
        this.interpolators.forEach(TrilinearInterpolator::initializeForFirstCellX);
    }

    public void advanceCellX(int cellX) {
        this.interpolators.forEach(i -> i.advanceCellX(cellX));
    }

    public void selectCellYZ(int cellY, int cellZ) {
        this.interpolators.forEach(i -> i.selectCellYZ(cellY, cellZ));
    }

    public void updateForXZ(double x, double z) {
        this.interpolators.forEach(i -> i.updateForXZ(x, z));
    }

    public void updateForY(double y) {
        this.interpolators.forEach(i -> i.updateForY(y));
    }

    public void swapSlices() {
        this.interpolators.forEach(TrilinearInterpolator::swapSlices);
    }
}

