/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.CenterOrDistanceNoise;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public abstract class CenterOrDistanceToPlacement<T extends CenterOrDistanceNoise>
extends PlacementModifier {
    final boolean center;
    final float distance;
    private final ThreadLocal<LocalContext<T>> localContext;

    public static <E extends CenterOrDistanceToPlacement<?>> MapCodec<E> codec(BiFunction<Boolean, Float, E> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("center", (Object)false).forGetter(c -> c.center), (App)Codecs.UNIT_FLOAT.optionalFieldOf("distance", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.distance))).apply((Applicative)instance, factory));
    }

    public CenterOrDistanceToPlacement(boolean center, float distance) {
        this.center = center;
        this.distance = distance;
        this.localContext = ThreadLocal.withInitial(() -> null);
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        Biome biome;
        BiomeExtension extension;
        WorldGenLevel level = context.getLevel();
        long seed = level.getSeed();
        LocalContext<T> local = this.localContext.get();
        if (local == null || local.seed != seed) {
            local = new LocalContext<T>(seed, this.createContext(Seed.unsafeOf(seed)));
            this.localContext.set(local);
        }
        if (((CenterOrDistanceNoise)local.context).isValidBiome(extension = TFCBiomes.getExtensionOrThrow((LevelAccessor)level, biome = (Biome)level.getBiome(pos).value()))) {
            if (this.center) {
                BlockPos center = ((CenterOrDistanceNoise)local.context).calculateCenter(pos, extension);
                if (center != null && SectionPos.blockToSectionCoord((int)center.getX()) == SectionPos.blockToSectionCoord((int)pos.getX()) && SectionPos.blockToSectionCoord((int)center.getZ()) == SectionPos.blockToSectionCoord((int)pos.getZ())) {
                    return Stream.of(center);
                }
            } else if (((CenterOrDistanceNoise)local.context).calculateEasing(pos, extension) > this.distance) {
                return Stream.of(pos);
            }
        }
        return Stream.empty();
    }

    protected abstract T createContext(Seed var1);

    private record LocalContext<T>(long seed, T context) {
    }
}

