/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class IntertidalPlacement
extends PlacementModifier {
    public static final MapCodec<IntertidalPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("min_elevation", (Object)-64).forGetter(c -> c.minElevation), (App)Codec.INT.optionalFieldOf("max_elevation", (Object)320).forGetter(c -> c.maxElevation)).apply((Applicative)instance, IntertidalPlacement::new));
    private final int minElevation;
    private final int maxElevation;

    public IntertidalPlacement(int minElevation, int maxElevation) {
        this.minElevation = minElevation;
        this.maxElevation = maxElevation;
    }

    public int getMinElevation() {
        return this.minElevation;
    }

    public int getMaxElevation() {
        return this.maxElevation;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TFCPlacements.INTERTIDAL.get();
    }

    public boolean isValid(Noise2D highTideNoise, BlockPos pos) {
        int heightDiff = (int)((double)pos.getY() - highTideNoise.noise(pos.getX(), pos.getZ()));
        return this.minElevation <= heightDiff && heightDiff <= this.maxElevation;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        Seed seed = Seed.of(context.getLevel().getSeed());
        Noise2D highTideHeightNoise = BiomeNoise.shoreTideLevelNoise(seed);
        if (this.isValid(highTideHeightNoise, pos)) {
            return Stream.of(pos);
        }
        return Stream.empty();
    }
}

