/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class NoSolidNeighborsPlacement
extends PlacementModifier {
    public static final MapCodec<NoSolidNeighborsPlacement> CODEC = MapCodec.unit((Object)((Object)new NoSolidNeighborsPlacement()));

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        return !this.hasNoSolidNeighbors(context, pos) ? Stream.of(pos) : Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TFCPlacements.NO_SOLID_NEIGHBORS.get();
    }

    private boolean hasNoSolidNeighbors(PlacementContext level, BlockPos pos) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (this.isNonSolid(level, (BlockPos)cursor.setWithOffset((Vec3i)pos, dir))) continue;
            return true;
        }
        return false;
    }

    private boolean isNonSolid(PlacementContext level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return EnvironmentHelpers.isWorldgenReplaceable(state) || Helpers.isBlock(state, TFCTags.Blocks.CAN_BE_SNOW_PILED);
    }
}

