/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public enum AnnotateBaseLandHeight implements RegionTask
{
    INSTANCE;

    private static final int ISLAND_SEED_DEPTH = 3;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet explored = new BitSet(region.size());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        IntArrayList islandQueue = new IntArrayList();
        RandomSource random = context.random;
        for (Region.Point point : region.points()) {
            if (!point.land()) continue;
            point.baseLandHeight = point.distanceToOcean;
            if (point.baseLandHeight > point.distanceToEdge) {
                point.baseLandHeight = (byte)(0.3f * (float)point.baseLandHeight + 0.7f * (float)point.distanceToEdge);
            }
            explored.set(point.index);
            if (point.island()) {
                point.baseOceanDepth = (byte)3;
                islandQueue.add(point.index);
                continue;
            }
            point.baseOceanDepth = 0;
            queue.enqueue(point.index);
        }
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.atIndex(last);
            int nextDepth = lastPoint.baseOceanDepth + 1;
            if (nextDepth == 3 && !islandQueue.isEmpty()) {
                islandQueue.forEach(arg_0 -> ((IntArrayFIFOQueue)queue).enqueue(arg_0));
                islandQueue.clear();
            }
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    @Nullable Region.Point point = region.atOffset(last, dx, dz);
                    if (point == null || point.land() || point.baseOceanDepth != 0) continue;
                    if (!explored.get(point.index)) {
                        if (random.nextInt(15) == 0) {
                            point.baseOceanDepth = lastPoint.baseOceanDepth;
                            queue.enqueueFirst(point.index);
                        } else {
                            point.baseOceanDepth = (byte)nextDepth;
                            queue.enqueue(point.index);
                        }
                    }
                    explored.set(point.index);
                }
            }
        }
    }
}

