/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public enum AnnotateBiomeAltitude implements RegionTask
{
    INSTANCE;

    public static final int WIDTH = 4;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        RandomSource random = context.random;
        BitSet explored = new BitSet(region.size());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (Region.Point point : region.points()) {
            if (!point.land() || !point.mountain()) continue;
            point.biomeAltitude = (byte)12;
            queue.enqueue(point.index);
            explored.set(point.index);
        }
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.atIndex(last);
            int nextAltitude = lastPoint.biomeAltitude - 1;
            if (nextAltitude < 0) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    @Nullable Region.Point point = region.atOffset(last, dx, dz);
                    if (point == null || !point.land() || point.biomeAltitude != 0 || explored.get(point.index)) continue;
                    if (random.nextInt(13) == 0 && lastPoint.biomeAltitude != 12) {
                        point.biomeAltitude = lastPoint.biomeAltitude;
                        queue.enqueueFirst(point.index);
                    } else {
                        point.biomeAltitude = (byte)nextAltitude;
                        queue.enqueue(point.index);
                    }
                    explored.set(point.index);
                }
            }
        }
        for (Region.Point point : region.points()) {
            if (!point.land() || point.discreteBiomeAltitude() != 0 || point.baseLandHeight < 4) continue;
            if (point.discreteBiomeAltitude() == 0 && point.baseLandHeight >= 4) {
                point.biomeAltitude = (byte)4;
            }
            if (point.discreteBiomeAltitude() != 1 || point.baseLandHeight < 11) continue;
            point.biomeAltitude = (byte)8;
        }
    }
}

