/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.Mth;

public final class AnnotateClimate
extends Enum<AnnotateClimate>
implements RegionTask {
    public static final /* enum */ AnnotateClimate INSTANCE = new AnnotateClimate();
    private static final /* synthetic */ AnnotateClimate[] $VALUES;

    public static AnnotateClimate[] values() {
        return (AnnotateClimate[])$VALUES.clone();
    }

    public static AnnotateClimate valueOf(String name) {
        return Enum.valueOf(AnnotateClimate.class, name);
    }

    @Override
    public void apply(RegionGenerator.Context context) {
        for (Region.Point point : context.region.points()) {
            float bias;
            int x = point.x;
            int z = point.z;
            point.temperature = (float)context.generator().temperatureNoise.noise(x, z);
            point.rainfall = (float)context.generator().rainfallNoise.noise(x, z);
            if (point.land()) {
                assert (point.distanceToOcean >= 0);
                float potentialBias = Mth.clampedMap((float)point.distanceToEdge, (float)2.0f, (float)6.0f, (float)0.0f, (float)1.0f);
                float oceanProximityBias = Mth.clampedMap((float)point.distanceToOcean, (float)2.0f, (float)6.0f, (float)0.0f, (float)1.0f);
                bias = Math.min(potentialBias, oceanProximityBias);
            } else {
                bias = 0.0f;
            }
            point.rainfallVariance = Mth.clampedMap((float)((float)point.distanceToWestCoast + (float)context.generator().rainfallVarianceNoise.noise(x, z)), (float)0.0f, (float)80.0f, (float)-1.0f, (float)1.0f);
            float biasTargetTemperature = Mth.lerp((float)bias, (float)5.0f, (float)point.temperature);
            float biasTargetRainfall = Mth.lerp((float)bias, (float)Math.min(point.rainfall + 350.0f, 500.0f), (float)point.rainfall);
            float tempDelta = Mth.clampedMap((float)((float)context.generator().oceanicInfluenceNoise.noise(x, z)), (float)-0.8f, (float)0.9f, (float)-0.07f, (float)0.23f);
            float oldTemp = point.temperature;
            point.temperature = Mth.lerp((float)tempDelta, (float)oldTemp, (float)biasTargetTemperature);
            float rainDelta = Mth.clampedMap((float)(point.temperature - oldTemp), (float)-2.0f, (float)2.0f, (float)0.0f, (float)0.25f);
            point.rainfall = Math.clamp(Mth.lerp((float)rainDelta, (float)point.rainfall, (float)biasTargetRainfall), 0.0f, 500.0f);
            float edgeBiasScale = Mth.clampedMap((float)point.distanceToEdge, (float)0.0f, (float)12.0f, (float)1.0f, (float)0.0f);
            point.rainfallVariance = Mth.lerp((float)edgeBiasScale, (float)point.rainfallVariance, (float)0.0f);
            point.rainfallVariance = Mth.clamp((float)point.rainfallVariance, (float)-1.0f, (float)1.0f);
        }
    }

    private static /* synthetic */ AnnotateClimate[] $values() {
        return new AnnotateClimate[]{INSTANCE};
    }

    static {
        $VALUES = AnnotateClimate.$values();
    }
}

