/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import org.jetbrains.annotations.Nullable;

public enum AnnotateDistanceToOcean implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet explored = new BitSet(region.size());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (Region.Point point : region.points()) {
            if (point == null || point.land()) continue;
            point.distanceToOcean = (byte)-1;
            queue.enqueue(point.index);
            explored.set(point.index);
        }
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.atIndex(last);
            int nextDistance = lastPoint.distanceToOcean + 1;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    @Nullable Region.Point point = region.atOffset(last, dx, dz);
                    if (point == null || !point.land() || point.distanceToOcean != 0) continue;
                    if (!lastPoint.land() && !point.island()) {
                        lastPoint.setShore();
                    }
                    if (!explored.get(point.index)) {
                        point.distanceToOcean = (byte)nextDistance;
                        queue.enqueue(point.index);
                    }
                    explored.set(point.index);
                }
            }
        }
    }
}

