/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import org.jetbrains.annotations.Nullable;

public enum ChooseRocks implements RegionTask
{
    INSTANCE;

    public static final int OCEAN = 0;
    public static final int VOLCANIC = 1;
    public static final int LAND = 2;
    public static final int UPLIFT = 3;
    public static final int TYPE_BITS = 2;
    public static final int TYPE_MASK = 3;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        Area rockArea = context.generator().rockArea.get();
        for (Region.Point point : region.points()) {
            point.rock = rockArea.get(point.x, point.z) << 2 | this.findClosestType(region, point, point.index);
        }
    }

    private int findClosestType(Region region, Region.Point center, int index) {
        int type = center.land() ? 2 : 0;
        int minDist = Integer.MAX_VALUE;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = 0; dz <= 2; ++dz) {
                @Nullable Region.Point point = region.atOffset(index, dx, dz);
                int dist = Math.abs(dx) + Math.abs(dz);
                if (point == null || dist >= minDist) continue;
                if (point.island() && dist < 4 || point.hotSpotAge > 0) {
                    type = 1;
                    minDist = dist;
                    continue;
                }
                if (!point.mountain() && !point.coastalMountain() || dist >= 3) continue;
                type = 3;
                minDist = dist;
            }
        }
        return type;
    }
}

