/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.River;
import net.dries007.tfc.world.river.RiverHelpers;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public final class RiverEdge {
    public static final int MIN_WIDTH = 8;
    public static final int MAX_WIDTH = 24;
    private static final int MAX_AFFECTING_GRID_DISTANCE = 1 + Mth.ceil((float)4.05f);
    public int width;
    private final River.Vertex source;
    private final River.Vertex drain;
    private final MidpointFractal fractal;
    final int minPartX;
    final int minPartZ;
    final int maxPartX;
    final int maxPartZ;
    private boolean sourceEdge;
    @Nullable
    private RiverEdge drainEdge;

    public RiverEdge(River.Edge edge, RandomSource random) {
        this.source = edge.source();
        this.drain = edge.drain();
        this.fractal = edge.fractal(random, 4);
        int centerGridX = (int)Math.round(0.5 * (edge.source().x() + edge.drain().x()));
        int centerGridZ = (int)Math.round(0.5 * (edge.source().y() + edge.drain().y()));
        this.minPartX = Units.gridToPart(centerGridX - MAX_AFFECTING_GRID_DISTANCE);
        this.minPartZ = Units.gridToPart(centerGridZ - MAX_AFFECTING_GRID_DISTANCE);
        this.maxPartX = Units.gridToPart(centerGridX + MAX_AFFECTING_GRID_DISTANCE);
        this.maxPartZ = Units.gridToPart(centerGridZ + MAX_AFFECTING_GRID_DISTANCE);
        this.sourceEdge = false;
        this.drainEdge = null;
    }

    public River.Vertex source() {
        return this.source;
    }

    public boolean sourceEdge() {
        return this.sourceEdge;
    }

    public River.Vertex drain() {
        return this.drain;
    }

    @Nullable
    public RiverEdge drainEdge() {
        return this.drainEdge;
    }

    public MidpointFractal fractal() {
        return this.fractal;
    }

    public int widthSq() {
        return this.width * this.width;
    }

    public double widthSq(double exactGridX, double exactGridZ) {
        double lerpFac = RiverHelpers.projectAlongLine(this.source().x(), this.source().y(), this.drain().y(), this.drain().y(), exactGridX, exactGridZ);
        double realWidth = Helpers.lerp(lerpFac, (double)this.width, this.drainEdge == null ? (double)this.width : (double)this.drainEdge.width);
        return realWidth * realWidth;
    }

    public void linkToDrain(@Nullable RiverEdge edge) {
        this.drainEdge = edge;
        if (edge != null) {
            edge.sourceEdge = true;
        }
    }
}

