/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Function;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.RiverHelpers;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public final class River {
    private static final double MIN_BRANCH_ANGLE = (double)0.4f;
    private static final int MIN_BRANCH_DISTANCE = 2;
    private static final int MIN_RIVER_EDGE_COUNT = 6;

    private static double distance(Edge edge, Vertex vertex) {
        return RiverHelpers.distancePointToLineSq(edge.source.x, edge.source.y, edge.drain.x, edge.drain.y, vertex.x, vertex.y);
    }

    private static boolean intersect(Vertex p1, Vertex q1, Vertex p2, Vertex q2) {
        int o1 = River.orientation(p1, q1, p2);
        int o2 = River.orientation(p1, q1, q2);
        int o3 = River.orientation(p2, q2, p1);
        int o4 = River.orientation(p2, q2, q1);
        return o1 != o2 && o3 != o4 || o1 == 0 && River.intersectCollinear(p1, p2, q1) || o2 == 0 && River.intersectCollinear(p1, q2, q1) || o3 == 0 && River.intersectCollinear(p2, p1, q2) || o4 == 0 && River.intersectCollinear(p2, q1, q2);
    }

    private static boolean intersectCollinear(Vertex p, Vertex q, Vertex r) {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }

    private static int orientation(Vertex p, Vertex q, Vertex r) {
        double value = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
        if (value == 0.0) {
            return 0;
        }
        return value > 0.0 ? 1 : 2;
    }

    public record Edge(Vertex source, Vertex drain) {
        public MidpointFractal fractal(RandomSource random, int bisections) {
            return new MidpointFractal(random, bisections, this.source.x, this.source.y, this.drain.x, this.drain.y);
        }
    }

    public record Vertex(double x, double y, double angle, double length, int distance) {
    }

    public static class MultiParallelBuilder
    implements Context {
        private final List<Builder> builders = new ArrayList<Builder>();

        public Context add(Builder builder) {
            this.builders.add(builder);
            return this;
        }

        public <E> List<E> build(Function<Edge, E> map) {
            PriorityQueue<Builder> working = new PriorityQueue<Builder>(Comparator.comparing(b -> -b.edges.size() - 10 * b.branchQueue.size()));
            for (Builder builder : this.builders) {
                if (!builder.buildInitialBranch(this)) continue;
                working.offer(builder);
            }
            while (!working.isEmpty()) {
                Builder builder = working.poll();
                if (builder.buildBranch(this)) continue;
                working.offer(builder);
            }
            return this.builders.stream().flatMap(e -> e.edges.stream().map(map)).toList();
        }

        @Override
        public boolean intersectAny(Edge edge) {
            if (!this.isLegal(edge.drain, edge.source)) {
                return true;
            }
            for (Builder builder : this.builders) {
                if (!builder.intersectAny(edge)) continue;
                return true;
            }
            return false;
        }

        protected boolean isLegal(Vertex prev, Vertex vertex) {
            return true;
        }
    }

    public static class Builder
    implements Context {
        private final Queue<Edge> branchQueue = new LinkedList<Edge>();
        private final RandomSource random;
        private final List<Edge> edges;
        private final Vertex root;
        private final List<Edge> branch;
        private final int depth;
        private final double featherSq;

        public Builder(RandomSource random, double drainX, double drainY, double angle, double length, int depth, double feather) {
            this.random = random;
            this.edges = new ArrayList<Edge>();
            this.root = new Vertex(drainX, drainY, angle, length, 0);
            this.branch = new ArrayList<Edge>();
            this.depth = depth;
            this.featherSq = feather * feather;
        }

        private boolean buildInitialBranch(Context context) {
            Vertex prev = this.root;
            int length = this.depth + this.random.nextInt(1 + (int)((float)this.depth * 0.3f));
            for (int i = 0; i < length; ++i) {
                Vertex next = this.computeNext(prev, prev.length, prev.distance);
                Edge nextEdge = new Edge(next, prev);
                if (context.intersectAny(nextEdge)) {
                    this.pruneRiverIfTooShort();
                    return true;
                }
                this.edges.add(nextEdge);
                prev = next;
                if (prev.distance >= this.depth || prev.distance < 2) continue;
                this.branchQueue.offer(nextEdge);
            }
            return false;
        }

        private boolean buildBranch(Context context) {
            Vertex next;
            Edge nextEdge;
            if (this.branchQueue.isEmpty()) {
                this.pruneRiverIfTooShort();
                return true;
            }
            Edge prevEdge = this.branchQueue.poll();
            Vertex prev = prevEdge.drain;
            int prevDist = prev.distance + this.random.nextInt(3);
            Vertex branchNext = this.computeNext(prev, prev.length, prevDist);
            double deltaAngle = Math.abs(prevEdge.source.angle - branchNext.angle);
            if (deltaAngle < (double)0.4f || Math.PI * 2 - deltaAngle < (double)0.4f) {
                return false;
            }
            this.branch.clear();
            Edge first = new Edge(branchNext, prev);
            if (context.intersectAny(first)) {
                return false;
            }
            this.branch.add(first);
            prev = branchNext;
            for (int i = 0; i < this.depth - prev.distance + this.random.nextInt(1 + (int)((float)this.depth * 0.3f)) && !context.intersectAny(nextEdge = new Edge(next = this.computeNext(prev, prev.length, prevDist), prev)); ++i) {
                this.branch.add(nextEdge);
                prev = next;
                prevDist = next.distance;
                if (prevDist >= this.depth || prevDist < 2) continue;
                this.branchQueue.offer(nextEdge);
            }
            this.edges.addAll(this.branch);
            return false;
        }

        private void pruneRiverIfTooShort() {
            if (this.edges.size() < 6) {
                this.edges.clear();
                this.branchQueue.clear();
            }
        }

        @Override
        public boolean intersectAny(Edge edge) {
            for (Edge e : this.edges) {
                if (e.source == edge.drain || e.drain == edge.drain || !(River.distance(e, edge.source) < this.featherSq) && !River.intersect(e.source, e.drain, edge.source, edge.drain)) continue;
                return true;
            }
            return false;
        }

        private Vertex computeNext(Vertex prev, double length, int distance) {
            double nextAngle = distance == 0 ? prev.angle() : prev.angle() + (this.random.nextDouble() * 0.5 + (double)0.2f) * (double)(this.random.nextBoolean() ? 1 : -1);
            double nextLength = length * (this.random.nextDouble() * (double)0.08f + (double)0.92f);
            double dx = (double)Mth.cos((float)((float)nextAngle)) * nextLength;
            double dy = (double)Mth.sin((float)((float)nextAngle)) * nextLength;
            double x = prev.x() + dx;
            double y = prev.y() + dy;
            return new Vertex(x, y, nextAngle, nextLength, distance + 1);
        }
    }

    public static interface Context {
        public boolean intersectAny(Edge var1);
    }
}

