/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import java.util.function.Function;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.river.RiverNoise;
import net.dries007.tfc.world.river.RiverNoiseSampler;

public enum RiverBlendType {
    NONE(seed -> RiverNoiseSampler.NONE),
    BANKED(RiverNoise::banked),
    TALL_BANKED(RiverNoise::tallBanked),
    FLOODPLAIN(RiverNoise::floodplain),
    WIDE(RiverNoise::wide),
    WIDE_DEEP(RiverNoise::wideDeep),
    CANYON(RiverNoise::canyon),
    TALL_CANYON(RiverNoise::tallCanyon),
    TALUS(RiverNoise::talus),
    TERRACES(RiverNoise::terraces),
    CAVE(RiverNoise::cave);

    public static final RiverBlendType[] ALL;
    public static final int SIZE;
    private final Function<Seed, RiverNoiseSampler> factory;

    private RiverBlendType(Function<Seed, RiverNoiseSampler> factory) {
        this.factory = factory;
    }

    public RiverNoiseSampler createNoiseSampler(Seed seed) {
        return this.factory.apply(seed);
    }

    static {
        ALL = RiverBlendType.values();
        SIZE = ALL.length;
    }
}

