/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.Noise3D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.noise.OpenSimplex3D;
import net.dries007.tfc.world.river.RiverInfo;
import net.dries007.tfc.world.river.RiverNoiseSampler;
import net.minecraft.util.Mth;

public final class RiverNoise {
    public static RiverNoiseSampler banked(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D distNoise;
            final Noise2D bankCutNoise;
            double height;
            {
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(3).spread(0.05f).scaled(-0.2f, 0.2f);
                this.bankCutNoise = new OpenSimplex2D(seed.next()).octaves(3).abs().spread(0.025).scaled(0.0, 1.0, 59.0, 93.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = info.normDistSq() * (double)0.8f + this.distNoise.noise(x, z);
                double riverHeight = 57.0 + (distFac < 1.0 ? distFac * 6.0 : 6.0);
                double heightInWeight = Mth.clamp((double)(distFac - 1.0), (double)0.0, (double)2.0);
                double riverWeight = 2.0 - heightInWeight;
                this.height = Math.min((heightIn * heightInWeight + riverHeight * riverWeight) / 2.0, this.bankCutNoise.noise(x, z));
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler tallBanked(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D distNoise;
            final Noise2D surfaceNoise;
            double height;
            {
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(3).spread(0.05f).scaled(-0.2f, 0.2f);
                this.surfaceNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.07).scaled(-2.0, 2.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = info.normDistSq() * (double)0.8f + this.distNoise.noise(x, z);
                double riverHeight = 57.0 + (distFac < 1.0 ? distFac * 9.0 : 9.0) + this.surfaceNoise.noise(x, z);
                double heightInWeight = Mth.clamp((double)(distFac - 1.0), (double)0.0, (double)2.0);
                double riverWeight = 2.0 - heightInWeight;
                this.height = (heightIn * heightInWeight + riverHeight * riverWeight) / 2.0;
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler floodplain(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D distNoise;
            double height;
            {
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-0.2f, 0.2f);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double riverHeight;
                double distFac = info.normDistSq() * (double)0.8f + this.distNoise.noise(x, z);
                if (distFac < 1.0) {
                    riverHeight = 58.5 + distFac * 3.0;
                } else if (distFac < 2.0) {
                    riverHeight = 61.5;
                } else {
                    double heightInWeight = Mth.clamp((double)(2.0 * distFac - 4.0), (double)0.0, (double)1.0);
                    double riverWeight = 1.0 - heightInWeight;
                    riverHeight = 61.5 * riverWeight + heightIn * heightInWeight;
                }
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler wide(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D distNoise;
            double height;
            {
                this.baseNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-2.5, 1.5);
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-0.15f, 0.15f);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = info.normDistSq() * (double)0.8f + this.distNoise.noise(x, z);
                double riverHeight = 58.0 + distFac * 7.0 + this.baseNoise.noise(x, z);
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler wideDeep(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D distNoise;
            double height;
            {
                this.baseNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-2.5, 1.5);
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-0.15f, 0.15f);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = info.normDistSq() * (double)0.8f + this.distNoise.noise(x, z);
                double riverHeight = 55.0 + distFac * 7.0 + this.baseNoise.noise(x, z);
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler canyon(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D distNoise;
            final Noise2D lowFreqCliffNoise;
            double height;
            {
                this.baseNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-7.0, 3.0);
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-0.3f, 0.2f);
                this.lowFreqCliffNoise = new OpenSimplex2D(seed.next()).spread(7.0E-4f).clamped(0.0, 1.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = info.normDistSq() * 1.3 + this.distNoise.noise(x, z);
                double adjDistFac = distFac > 0.6 ? distFac * 0.4 + 0.8 : distFac;
                double riverHeight = 55.0 + Mth.lerp((double)this.lowFreqCliffNoise.noise(x, z), (double)distFac, (double)adjDistFac) * 16.0 + this.baseNoise.noise(x, z);
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler tallCanyon(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D distNoise;
            final Noise3D cliffNoise;
            private double distFac;
            private int x;
            private int z;
            {
                this.baseNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-7.0, 3.0);
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-0.3f, 0.2f);
                this.cliffNoise = new OpenSimplex3D(seed.next()).octaves(2).spread(0.1f).scaled(0.0, 3.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = info.normDistSq() * 1.3 + this.distNoise.noise(x, z);
                double adjDistFac = distFac > 0.32 ? distFac * 0.2 + 1.6 : distFac;
                double riverHeight = 55.0 + adjDistFac * 16.0 + this.baseNoise.noise(x, z);
                this.distFac = Math.max(0.0, distFac * 0.7);
                this.x = x;
                this.z = z;
                return Math.min(riverHeight, heightIn);
            }

            @Override
            public double noise(int y, double noiseIn) {
                return Mth.clampedLerp((double)this.rawNoise(y), (double)noiseIn, (double)this.distFac);
            }

            private double rawNoise(int y) {
                if (y > 98) {
                    return 0.0;
                }
                if (y > 83) {
                    double easing = 1.0f - (float)(y - 63 - 20) / 15.0f;
                    return easing * this.cliffNoise.noise(this.x, y, this.z);
                }
                if (y > 63) {
                    return this.cliffNoise.noise(this.x, y, this.z);
                }
                if (y > 55) {
                    double easing = (double)(y - 63 + 8) / 8.0;
                    return easing * this.cliffNoise.noise(this.x, y, this.z);
                }
                return 0.0;
            }
        };
    }

    public static RiverNoiseSampler talus(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D cliffHeightNoise;
            final Noise2D distNoise;
            double height;
            {
                this.baseNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-2.5, 1.5);
                this.cliffHeightNoise = new OpenSimplex2D(seed.next()).octaves(2).spread(0.1f).scaled(3.0, 8.0);
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-0.15f, 0.15f);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = Math.sqrt(info.normDistSq()) + this.distNoise.noise(x, z);
                double talusRiverHeight = 55.0 + distFac * 12.0 + this.baseNoise.noise(x, z) + (distFac > 1.5 ? this.cliffHeightNoise.noise(x, z) : 0.0);
                double canyonRiverHeight = 55.0 + info.normDistSq() * 1.3 * 16.0;
                double riverHeight = Mth.clampedMap((double)thisWeight, (double)0.9, (double)1.0, (double)canyonRiverHeight, (double)talusRiverHeight);
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler terraces(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D baseNoise;
            final Noise2D cliffHeightNoise;
            final Noise2D cliffBaseNoise;
            final Noise2D distNoise;
            double height;
            {
                this.baseNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-2.5, 1.5);
                this.cliffHeightNoise = new OpenSimplex2D(seed.next()).octaves(2).spread(0.1f).scaled(4.0, 8.0);
                this.cliffBaseNoise = new OpenSimplex2D(seed.next()).octaves(2).spread(0.06f).scaled(61.0, 67.0);
                this.distNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.05f).scaled(-0.15f, 0.15f);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                double distFac = Math.sqrt(info.normDistSq()) * 0.85 + this.distNoise.noise(x, z);
                double slopedRiverHeight = 54.0 + distFac * 12.0 + this.baseNoise.noise(x, z);
                double cliffBaseHeight = this.cliffBaseNoise.noise(x, z);
                double cliffHeight = this.cliffHeightNoise.noise(x, z);
                double lowerTerrace = slopedRiverHeight > cliffBaseHeight ? Mth.clampedMap((double)slopedRiverHeight, (double)cliffBaseHeight, (double)(cliffBaseHeight + 1.1), (double)0.0, (double)cliffHeight) : 0.0;
                double upperTerrace = slopedRiverHeight > cliffBaseHeight + cliffHeight ? Mth.clampedMap((double)slopedRiverHeight, (double)(cliffBaseHeight + cliffHeight), (double)(cliffBaseHeight + cliffHeight + 1.4), (double)0.0, (double)(cliffHeight + 4.0)) : 0.0;
                double terraceRiverHeight = slopedRiverHeight + lowerTerrace + upperTerrace;
                double canyonRiverHeight = 55.0 + info.normDistSq() * 1.3 * 16.0;
                double riverHeight = Mth.clampedMap((double)thisWeight, (double)0.9, (double)1.0, (double)canyonRiverHeight, (double)terraceRiverHeight);
                this.height = Math.min(riverHeight, heightIn);
                return this.height;
            }

            @Override
            public double noise(int y, double noiseIn) {
                return (double)y > this.height ? 0.0 : noiseIn;
            }
        };
    }

    public static RiverNoiseSampler cave(final Seed seed) {
        return new RiverNoiseSampler(){
            final Noise2D carvingCenterNoise;
            final Noise2D carvingHeightNoise;
            double distSquared;
            double weight;
            double height;
            double carvingHeight;
            double carvingCenter;
            {
                this.carvingCenterNoise = new OpenSimplex2D(seed.next()).octaves(2).spread(0.02f).scaled(60.0, 66.0);
                this.carvingHeightNoise = new OpenSimplex2D(seed.next()).octaves(4).spread(0.15f).scaled(8.0, 14.0);
            }

            @Override
            public double setColumnAndSampleHeight(RiverInfo info, int x, int z, double heightIn, double caveWeight, double thisWeight) {
                this.distSquared = Mth.clamp((double)(info.normDistSq() * 1.3 - 0.1), (double)0.0, (double)1.0);
                this.weight = caveWeight;
                this.height = heightIn;
                this.carvingHeight = this.carvingHeightNoise.noise(x, z);
                this.carvingCenter = this.carvingCenterNoise.noise(x, z);
                double maxHeight = this.carvingCenter + this.carvingHeight;
                if (caveWeight > 0.75) {
                    return heightIn;
                }
                double canyonMaxHeight = Math.min(55.0 + info.normDistSq() * 1.3 * 16.0, heightIn);
                if (caveWeight > 0.5) {
                    double interiorHeight = Mth.map((double)caveWeight, (double)0.5, (double)0.75, (double)Math.min(maxHeight, heightIn), (double)heightIn);
                    double exteriorHeight = Mth.map((double)caveWeight, (double)0.5, (double)0.75, (double)Math.min(canyonMaxHeight, heightIn), (double)heightIn);
                    this.height = Mth.lerp((double)this.distSquared, (double)interiorHeight, (double)exteriorHeight);
                    return this.height;
                }
                return canyonMaxHeight;
            }

            @Override
            public double noise(int y, double noiseIn) {
                double vertDistance = ((double)y - this.carvingCenter) / this.carvingHeight;
                if (vertDistance > 0.0) {
                    vertDistance = vertDistance * this.weight * this.weight;
                }
                double columnNoise = Math.max(1.0 - vertDistance * vertDistance, 0.0);
                double noise = Mth.lerp((double)this.distSquared, (double)columnNoise, (double)noiseIn);
                return noise * Mth.clampedMap((double)this.weight, (double)0.5, (double)0.25, (double)1.0, (double)0.0);
            }
        };
    }
}

