/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class RockLayerSettings {
    public static final Codec<RockLayerSettings> CODEC = Data.CODEC.comapFlatMap(RockLayerSettings::decode, r -> r.data);
    private final List<Layer> oceanFloor;
    private final List<Layer> land;
    private final List<Layer> volcanic;
    private final List<Layer> uplift;
    private final Map<Block, RockSettings> rockBlocks;
    private final Map<Block, Block> rawToHardened;
    private final Data data;

    public static DataResult<RockLayerSettings> decode(Data data) {
        ArrayList<Layer> bottom = new ArrayList<Layer>();
        for (String string : data.bottom) {
            RockSettings rock = data.rocks.get(string);
            if (rock == null) {
                return DataResult.error(() -> "No rock with id: " + string);
            }
            bottom.add(new Layer(rock, bottom));
        }
        HashMap<String, List<Layer>> layers = new HashMap<String, List<Layer>>();
        layers.put("bottom", bottom);
        for (LayerData layer : data.layers) {
            ArrayList<Layer> baked = new ArrayList<Layer>();
            if (layers.containsKey(layer.id)) {
                return DataResult.error(() -> "More than one layer named " + layer.id);
            }
            for (Map.Entry<String, String> entry : layer.layers.entrySet()) {
                List next = (List)layers.get(entry.getValue());
                if (next == null) {
                    return DataResult.error(() -> "No layer with id: " + (String)entry.getValue());
                }
                RockSettings rock = data.rocks.get(entry.getKey());
                if (rock == null) {
                    return DataResult.error(() -> "No rock with id: " + (String)entry.getKey());
                }
                baked.add(new Layer(rock, next));
            }
            layers.put(layer.id, baked);
        }
        MutableObject mutableObject = new MutableObject();
        List<Layer> oceanFloor = RockLayerSettings.processTopLevel(layers, data.oceanFloor, (Mutable<String>)mutableObject);
        List<Layer> land = RockLayerSettings.processTopLevel(layers, data.land, (Mutable<String>)mutableObject);
        List<Layer> volcanic = RockLayerSettings.processTopLevel(layers, data.volcanic, (Mutable<String>)mutableObject);
        List<Layer> uplift = RockLayerSettings.processTopLevel(layers, data.uplift, (Mutable<String>)mutableObject);
        return mutableObject.getValue() != null ? DataResult.error(() -> ((Mutable)mutableObject).getValue()) : DataResult.success((Object)new RockLayerSettings(oceanFloor, land, volcanic, uplift, data));
    }

    private static List<Layer> processTopLevel(Map<String, List<Layer>> layers, List<String> entries, Mutable<String> error) {
        ArrayList<Layer> baked = new ArrayList<Layer>();
        for (String id : entries) {
            List<Layer> layer = layers.get(id);
            if (layer == null) {
                error.setValue((Object)("No layer with id: " + id));
                continue;
            }
            baked.addAll(layer);
        }
        return baked;
    }

    private RockLayerSettings(List<Layer> oceanFloor, List<Layer> land, List<Layer> volcanic, List<Layer> uplift, Data data) {
        this.oceanFloor = oceanFloor;
        this.land = land;
        this.volcanic = volcanic;
        this.uplift = uplift;
        this.data = data;
        this.rockBlocks = new IdentityHashMap<Block, RockSettings>();
        for (RockSettings rock : data.rocks.values()) {
            this.rockBlocks.put(rock.raw(), rock);
            this.rockBlocks.put(rock.hardened(), rock);
            this.rockBlocks.put(rock.gravel(), rock);
            this.rockBlocks.put(rock.cobble(), rock);
            this.rockBlocks.put(rock.gravel(), rock);
            this.rockBlocks.put(rock.sand(), rock);
            this.rockBlocks.put(rock.sandstone(), rock);
            rock.loose().ifPresent(loose -> this.rockBlocks.put((Block)loose, rock));
            rock.mossyLoose().ifPresent(loose -> this.rockBlocks.put((Block)loose, rock));
            rock.spike().ifPresent(spike -> this.rockBlocks.put((Block)spike, rock));
        }
        this.rawToHardened = this.getRocks().stream().collect(Collectors.toMap(RockSettings::raw, RockSettings::hardened));
    }

    @Nullable
    public Block getHardened(Block raw) {
        return this.rawToHardened.get(raw);
    }

    @Nullable
    public RockSettings getRock(Block block) {
        return this.rockBlocks.get(block);
    }

    public Collection<RockSettings> getRocks() {
        return this.data.rocks.values();
    }

    public RockSettings sampleAtLayer(int pointRock, int layerN) {
        XoroshiroRandomSource source = new XoroshiroRandomSource((long)(pointRock >> 2));
        List<Layer> rootLayers = switch (pointRock & 3) {
            case 0 -> this.oceanFloor;
            case 1 -> this.volcanic;
            case 2 -> this.land;
            default -> this.uplift;
        };
        Layer layer = rootLayers.get(source.nextInt(rootLayers.size()));
        for (int i = 0; i < layerN; ++i) {
            layer = layer.next.get(source.nextInt(layer.next.size()));
        }
        return layer.rock;
    }

    public Sampler sampler(final int pointRock) {
        final List<Layer> initialLayer = switch (pointRock & 3) {
            case 0 -> this.oceanFloor;
            case 1 -> this.volcanic;
            case 2 -> this.land;
            default -> this.uplift;
        };
        return new Sampler(){
            final RandomSource source;
            List<Layer> layer;
            {
                this.source = new XoroshiroRandomSource((long)(pointRock >> 2));
                this.layer = initialLayer;
            }

            @Override
            public RockSettings next() {
                Layer chosen = this.layer.get(this.source.nextInt(this.layer.size()));
                this.layer = chosen.next();
                return chosen.rock();
            }
        };
    }

    public record Data(Map<String, RockSettings> rocks, List<String> bottom, List<LayerData> layers, List<String> oceanFloor, List<String> land, List<String> volcanic, List<String> uplift) {
        static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, RockSettings.CODEC).fieldOf("rocks").forGetter(c -> c.rocks), (App)Codec.STRING.listOf().fieldOf("bottom").forGetter(c -> c.bottom), (App)LayerData.CODEC.listOf().fieldOf("layers").forGetter(c -> c.layers), (App)Codec.STRING.listOf().fieldOf("ocean_floor").forGetter(c -> c.oceanFloor), (App)Codec.STRING.listOf().fieldOf("land").forGetter(c -> c.land), (App)Codec.STRING.listOf().fieldOf("volcanic").forGetter(c -> c.volcanic), (App)Codec.STRING.listOf().fieldOf("uplift").forGetter(c -> c.uplift)).apply((Applicative)instance, Data::new));
    }

    public record Layer(RockSettings rock, List<Layer> next) {
    }

    public record LayerData(String id, Map<String, String> layers) {
        static final Codec<LayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(c -> c.id), (App)Codecs.orderPreservingUnboundedMapCodec(Codec.STRING, Codec.STRING).fieldOf("layers").forGetter(c -> c.layers)).apply((Applicative)instance, LayerData::new));
    }

    @FunctionalInterface
    public static interface Sampler {
        public RockSettings next();
    }
}

