/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.stateprovider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.function.Function;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.stateprovider.TFCStateProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;

public class RandomPropertyProvider
extends BlockStateProvider {
    public static final MapCodec<RandomPropertyProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codecs.BLOCK_STATE.fieldOf("state").forGetter(c -> c.state), (App)Codec.STRING.fieldOf("property").forGetter(c -> c.propertyName)).apply((Applicative)instance, RandomPropertyProvider::new));
    private final BlockState state;
    private final String propertyName;
    private Function<RandomSource, BlockState> propertySetter;

    public RandomPropertyProvider(BlockState state, String propertyName) {
        this.state = state;
        this.propertyName = propertyName;
        this.propertySetter = random -> state;
        Property property = state.getBlock().getStateDefinition().getProperty(propertyName);
        if (property != null) {
            this.propertySetter = this.createPropertySetter(property);
        }
    }

    private <T extends Comparable<T>> Function<RandomSource, BlockState> createPropertySetter(Property<T> property) {
        ArrayList values = new ArrayList(property.getPossibleValues());
        return random -> (BlockState)this.state.setValue(property, (Comparable)values.get(random.nextInt(values.size())));
    }

    public BlockState getState(RandomSource random, BlockPos pos) {
        return this.propertySetter.apply(random);
    }

    protected BlockStateProviderType<?> type() {
        return (BlockStateProviderType)TFCStateProviders.RANDOM_PROPERTY.get();
    }
}

