/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.stateprovider;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.feature.tree.RootConfig;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public record SpecialRootPlacer(float skewChance) {
    public static final Codec<SpecialRootPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("skew_chance").forGetter(c -> Float.valueOf(c.skewChance))).apply((Applicative)instance, SpecialRootPlacer::new));

    public boolean placeRoots(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos mutablePos, RootConfig config) {
        ArrayList positions = Lists.newArrayList();
        int oceanFloorY = level.getChunk((BlockPos)mutablePos).getHeight(Heightmap.Types.OCEAN_FLOOR_WG, mutablePos.getX(), mutablePos.getZ());
        if (oceanFloorY < 59) {
            return false;
        }
        mutablePos.setY(Math.max(oceanFloorY + random.nextInt(4), 64));
        positions.add(mutablePos.below());
        Direction guaranteedDirection = (Direction)Util.getRandom(Direction.Plane.HORIZONTAL.stream().toList(), (RandomSource)random);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == guaranteedDirection || random.nextInt(3) > 0) {
                BlockPos relativePos = mutablePos.relative(direction);
                ArrayList used = Lists.newArrayList();
                this.simulateRoots(level, random, relativePos, direction, (BlockPos)mutablePos, used, 0, config);
                positions.addAll(used);
            }
            positions.add(mutablePos.relative(direction));
        }
        for (BlockPos rootPos : positions) {
            this.placeRoot(level, random, rootPos, config);
        }
        return true;
    }

    private boolean simulateRoots(WorldGenLevel level, RandomSource random, BlockPos pos, Direction direction, BlockPos trunkOrigin, List<BlockPos> roots, int length, RootConfig config) {
        int maxLength = config.height();
        if (length != maxLength && roots.size() <= maxLength) {
            for (BlockPos blockpos : this.potentialRootPositions(pos, direction, random, trunkOrigin, config)) {
                if (!this.canPlaceRoot(level, blockpos, config)) continue;
                roots.add(blockpos);
                if (this.simulateRoots(level, random, blockpos, direction, trunkOrigin, roots, length + 1, config)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<BlockPos> potentialRootPositions(BlockPos pos, Direction direction, RandomSource random, BlockPos origin, RootConfig config) {
        BlockPos belowPos = pos.below();
        BlockPos relativePos = pos.relative(direction);
        int dist = pos.distManhattan((Vec3i)origin);
        int width = config.width();
        float f = this.skewChance;
        if (dist > width - 3 && dist <= width) {
            return random.nextFloat() < f ? List.of(belowPos, relativePos.below()) : List.of(belowPos);
        }
        if (dist > width) {
            return List.of(belowPos);
        }
        if (random.nextFloat() < f) {
            return List.of(belowPos);
        }
        return random.nextBoolean() ? List.of(relativePos) : List.of(belowPos);
    }

    private boolean canPlaceRoot(WorldGenLevel level, BlockPos pos, RootConfig config) {
        BlockState state = level.getBlockState(pos);
        return FluidHelpers.isAirOrEmptyFluid(state) || EnvironmentHelpers.isWorldgenReplaceable(state) || config.blocks().get(state.getBlock()) != null;
    }

    private void placeRoot(WorldGenLevel level, RandomSource random, BlockPos pos, RootConfig config) {
        if (this.canPlaceRoot(level, pos, config)) {
            BlockState stateAt = level.getBlockState(pos);
            IWeighted<BlockState> weighted = config.blocks().get(stateAt.getBlock());
            BlockState toPlace = weighted != null ? weighted.get(random) : ((Block)TFCBlocks.TREE_ROOTS.get()).defaultBlockState();
            BlockState filled = FluidHelpers.fillWithFluid(toPlace, level.getFluidState(pos).getType());
            level.setBlock(pos, filled == null ? toPlace : filled, 19);
        }
    }
}

