/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SoilSurfaceState
implements SurfaceState {
    public static final Noise2D PATCH_NOISE = new OpenSimplex2D(18273952837592L).octaves(2).spread(0.04f);
    private final List<SurfaceState> regions;

    public static SurfaceState buildSnowableSurface(SurfaceState snow, SurfaceState typical) {
        ImmutableList regions = ImmutableList.of((Object)snow, (Object)snow, (Object)SoilSurfaceState.transition(snow, typical), (Object)typical, (Object)typical, (Object)typical, (Object)typical, (Object)typical, (Object)typical, (Object)typical, (Object)typical, (Object)typical, (Object[])new SurfaceState[]{typical, typical, typical, typical, typical, typical});
        return new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState buildSurfaceType(SoilBlockType type, SurfaceState dry) {
        ImmutableList regions = ImmutableList.of((Object)SurfaceStates.SNOW, (Object)SurfaceStates.SNOW, (Object)SoilSurfaceState.transition(SurfaceStates.SNOW, dry), (Object)dry, (Object)SoilSurfaceState.transition(dry, SurfaceStates.COARSE_ARIDISOL_BASE), (Object)SurfaceStates.COARSE_ARIDISOL_BASE, (Object)SoilSurfaceState.transition(SurfaceStates.COARSE_ARIDISOL_BASE, SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), (Object)SoilSurfaceState.blobTransition(SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), SoilSurfaceState.transitioningSoil(type)), (Object)SoilSurfaceState.transitioningSoil(type), (Object)SoilSurfaceState.transitioningSoil(type), (Object)SoilSurfaceState.transitioningSoil(type), (Object[])new SurfaceState[]{SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type)});
        return type == SoilBlockType.GRASS ? new NeedsPostProcessing((List<SurfaceState>)regions) : new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState buildVolcanicSurfaceType(SoilBlockType type, SurfaceState dry) {
        ImmutableList regions = ImmutableList.of((Object)SurfaceStates.SNOW, (Object)SurfaceStates.SNOW, (Object)SoilSurfaceState.transition(SurfaceStates.SNOW, dry), (Object)dry, (Object)SoilSurfaceState.transition(dry, SurfaceStates.COARSE_ANDISOL_BASE), (Object)SurfaceStates.COARSE_ANDISOL_BASE, (Object)SoilSurfaceState.transition(SurfaceStates.COARSE_ANDISOL_BASE, SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object[])new SurfaceState[]{SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL)});
        return type == SoilBlockType.GRASS ? new NeedsPostProcessing((List<SurfaceState>)regions) : new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState buildMidType(SoilBlockType type, SurfaceState dry) {
        ImmutableList regions = ImmutableList.of((Object)SurfaceStates.PACKED_ICE, (Object)SoilSurfaceState.blobTransition(SurfaceStates.PACKED_ICE, dry), (Object)dry, (Object)dry, (Object)SoilSurfaceState.transition(dry, SurfaceStates.COARSE_ARIDISOL_BASE), (Object)SurfaceStates.COARSE_ARIDISOL_BASE, (Object)SoilSurfaceState.transition(SurfaceStates.COARSE_ARIDISOL_BASE, SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), (Object)SoilSurfaceState.blobTransition(SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), SoilSurfaceState.transitioningSoil(type)), (Object)SoilSurfaceState.transitioningSoil(type), (Object)SoilSurfaceState.transitioningSoil(type), (Object)SoilSurfaceState.transitioningSoil(type), (Object[])new SurfaceState[]{SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type)});
        return type == SoilBlockType.GRASS ? new NeedsPostProcessing((List<SurfaceState>)regions) : new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState buildVolcanicMidType(SoilBlockType type, SurfaceState dry) {
        ImmutableList regions = ImmutableList.of((Object)SurfaceStates.PACKED_ICE, (Object)SoilSurfaceState.blobTransition(SurfaceStates.PACKED_ICE, dry), (Object)dry, (Object)dry, (Object)SoilSurfaceState.transition(dry, SurfaceStates.COARSE_ANDISOL_BASE), (Object)SurfaceStates.COARSE_ANDISOL_BASE, (Object)SoilSurfaceState.transition(SurfaceStates.COARSE_ANDISOL_BASE, SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), (Object[])new SurfaceState[]{SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL), SoilSurfaceState.soil(type, SoilBlockType.Variant.ANDISOL)});
        return type == SoilBlockType.GRASS ? new NeedsPostProcessing((List<SurfaceState>)regions) : new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState buildUnderType() {
        ImmutableList regions = ImmutableList.of((Object)SurfaceStates.RAW, (Object)SurfaceStates.RAW, (Object)SoilSurfaceState.blobTransition(SurfaceStates.RAW, SurfaceStates.GRAVEL), (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object)SurfaceStates.GRAVEL, (Object[])new SurfaceState[]{SurfaceStates.GRAVEL, SurfaceStates.GRAVEL, SurfaceStates.GRAVEL, SurfaceStates.GRAVEL, SurfaceStates.GRAVEL, SurfaceStates.GRAVEL});
        return new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState buildDryDirt(SoilBlockType type) {
        ImmutableList regions = ImmutableList.of((Object)SurfaceStates.SNOW, (Object)SurfaceStates.SNOW, (Object)SoilSurfaceState.transition(SurfaceStates.SNOW, SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL)), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), (Object)SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), (Object)SoilSurfaceState.blobTransition(SoilSurfaceState.soil(type, SoilBlockType.Variant.ARIDISOL), SoilSurfaceState.transitioningSoil(type)), (Object)SoilSurfaceState.transitioningSoil(type), (Object)SoilSurfaceState.transitioningSoil(type), (Object)SoilSurfaceState.transitioningSoil(type), (Object[])new SurfaceState[]{SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type), SoilSurfaceState.transitioningSoil(type)});
        return new SoilSurfaceState((List<SurfaceState>)regions);
    }

    public static SurfaceState soil(SoilBlockType type, SoilBlockType.Variant variant) {
        Supplier block = TFCBlocks.SOIL.get((Object)type).get(variant);
        return arg_0 -> SoilSurfaceState.lambda$soil$0((Supplier)block, arg_0);
    }

    public static SurfaceState transitioningSoil(SoilBlockType type) {
        return SoilSurfaceState.transitioningSoil(type, SoilBlockType.Variant.ENTISOL, SoilBlockType.Variant.OXISOL, 16.0f, 16.7f);
    }

    public static SurfaceState transitioningSoil(SoilBlockType blockType, SoilBlockType.Variant coldSoilType, SoilBlockType.Variant hotSoilType, float transitionStartTemp, float transitionEndTemp) {
        return context -> {
            if (context.baseGroundwater() > 25.0f && (double)Math.abs(context.rainVariance()) > 0.5) {
                return ((Block)TFCBlocks.SOIL.get((Object)blockType).get(SoilBlockType.Variant.FLUVISOL).get()).defaultBlockState();
            }
            float temp = context.averageTemperature();
            BlockState coldBlock = ((Block)TFCBlocks.SOIL.get((Object)blockType).get(coldSoilType).get()).defaultBlockState();
            if (temp < transitionStartTemp) {
                return coldBlock;
            }
            BlockState hotBlock = ((Block)TFCBlocks.SOIL.get((Object)blockType).get(hotSoilType).get()).defaultBlockState();
            if (temp > transitionEndTemp) {
                return hotBlock;
            }
            BlockPos pos = context.pos();
            double noise = PATCH_NOISE.noise(pos.getX(), pos.getZ());
            return noise > 0.0 ? hotBlock : coldBlock;
        };
    }

    private static SurfaceState transition(SurfaceState first, SurfaceState second) {
        return context -> (Helpers.hash(729375982L, context.pos()) & 0x7F) > 63 ? first.getState(context) : second.getState(context);
    }

    private static SurfaceState blobTransition(SurfaceState first, SurfaceState second) {
        return context -> {
            BlockPos pos = context.pos();
            double noise = PATCH_NOISE.noise(pos.getX(), pos.getZ());
            return noise > 0.0 ? first.getState(context) : second.getState(context);
        };
    }

    private SoilSurfaceState(List<SurfaceState> regions) {
        this.regions = regions;
    }

    @Override
    public BlockState getState(SurfaceBuilderContext context) {
        float rainfall = context.groundWater();
        float temperature = Helpers.adjustAverageTemperatureByElevation(context.pos().getY(), context.averageTemperature(), context.getSeaLevel());
        int rainIndex = (int)Mth.clampedMap((float)rainfall, (float)35.0f, (float)450.0f, (float)3.0f, (float)((float)this.regions.size() - 0.01f));
        int tempIndex = (int)Mth.clampedMap((float)temperature, (float)-19.0f, (float)-4.0f, (float)0.0f, (float)((float)this.regions.size() - 0.01f));
        return this.regions.get(Math.min(rainIndex, tempIndex)).getState(context);
    }

    private static /* synthetic */ BlockState lambda$soil$0(Supplier block, SurfaceBuilderContext context) {
        return ((Block)block.get()).defaultBlockState();
    }

    static class NeedsPostProcessing
    extends SoilSurfaceState {
        private NeedsPostProcessing(List<SurfaceState> regions) {
            super(regions);
        }

        @Override
        public void setState(SurfaceBuilderContext context) {
            context.chunk().setBlockState(context.pos(), this.getState(context), false);
            context.chunk().markPosForPostprocessing(context.pos());
        }
    }
}

