/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class FlatsSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory MUDDY = seed -> new FlatsSurfaceBuilder(SurfaceStates.DRY_MUD, SurfaceStates.DRY_MUD, SurfaceStates.MUD);
    public static final SurfaceBuilderFactory SALTY = seed -> new FlatsSurfaceBuilder(SurfaceStates.SALTED_EARTH, SurfaceStates.DRY_MUD, SurfaceStates.MUD);
    private final SurfaceState top;
    private final SurfaceState mid;
    private final SurfaceState water;

    public FlatsSurfaceBuilder(SurfaceState top, SurfaceState mid, SurfaceState water) {
        this.top = top;
        this.mid = mid;
        this.water = water;
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        if (startY < 66 && context.baseGroundwater() < 25.0f) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, this.top, this.mid, this.mid, this.water, this.water);
        } else {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.TOP_GRASS_TO_SAND, SurfaceStates.MID_DIRT_TO_SAND, SurfaceStates.UNDER_GRAVEL);
        }
    }
}

