/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShoreAndOceanSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.world.level.block.state.BlockState;

public class IceSheetSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory NORMAL = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialBase(seed.seed()), BiomeNoise.iceSheetSurfaceHeight(seed.seed()), true, false, false);
    public static final SurfaceBuilderFactory EDGE = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialBase(seed.seed()).addConstant(1.6), BiomeNoise.iceSheetSurfaceHeight(seed.seed()), true, false, false);
    public static final SurfaceBuilderFactory EDGE_LAKE = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.lake(seed.seed()), BiomeNoise.iceSheetSurfaceHeight(seed.seed()), false, false, false);
    public static final SurfaceBuilderFactory HIDDEN_LAKE = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialOceanicBase(seed.seed()), BiomeNoise.iceSheetSurfaceHeight(seed.seed()), false, false, false);
    public static final SurfaceBuilderFactory ICE_SHEET_MOUNTAINS = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialCirques(seed.seed()).addConstant(39.0), BiomeNoise.montaneIceSheetSurfaceHeight(seed.seed()).max(BiomeNoise.glacialCirquesIceSurfaceHeight(seed.seed()).addConstant(39.0)), false, true, false);
    public static final SurfaceBuilderFactory GLACIATED_MOUNTAINS = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialCirques(seed.seed()).addConstant(39.0), BiomeNoise.glacialCirquesIceSurfaceHeight(seed.seed()).addConstant(39.0), false, true, false);
    public static final SurfaceBuilderFactory OCEANIC = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialOceanicBase(seed.seed()), BiomeNoise.oceanicIceSheetSurfaceHeight(seed.seed()), false, false, true);
    public static final SurfaceBuilderFactory ICE_SHEET_OCEANIC_MOUNTAINS = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialCirques(seed.seed()), BiomeNoise.oceanicIceSheetSurfaceHeight(seed.seed()).max(BiomeNoise.glacialCirquesIceSurfaceHeight(seed.seed())), false, true, true);
    public static final SurfaceBuilderFactory GLACIATED_OCEANIC_MOUNTAINS = seed -> new IceSheetSurfaceBuilder(seed, BiomeNoise.glacialCirques(seed.seed()), BiomeNoise.glacialCirquesIceSurfaceHeight(seed.seed()), false, true, true);
    private final Seed seed;
    private final Noise2D iceSurfaceNoise;
    private final Noise2D baseNoise;
    private final boolean hasMoraines;
    private final boolean hasStonyPeaks;
    private final boolean isShoreBiome;

    IceSheetSurfaceBuilder(Seed seed, Noise2D baseNoise, Noise2D iceSurfaceNoise, boolean hasMoraines, boolean hasStonyPeaks, boolean isShoreBiome) {
        this.seed = seed;
        this.baseNoise = baseNoise;
        this.iceSurfaceNoise = iceSurfaceNoise;
        this.hasMoraines = hasMoraines;
        this.hasStonyPeaks = hasStonyPeaks;
        this.isShoreBiome = isShoreBiome;
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        int iceDepth;
        int seaLevel = context.getSeaLevel();
        int x = context.pos().getX();
        int z = context.pos().getZ();
        int glacierBaseHeight = (int)Math.ceil(this.baseNoise.noise(x, z));
        int glacierSurfaceHeight = (int)Math.ceil(this.iceSurfaceNoise.noise(x, z));
        if (this.hasMoraines && context.baseGroundwater() <= 20.0f) {
            double moraineCrestHeight = Math.min(0.5 * (double)(glacierSurfaceHeight + glacierBaseHeight), (double)(glacierBaseHeight + 18));
            iceDepth = Math.max((int)(((double)startY - moraineCrestHeight) * 2.0), 0);
        } else {
            iceDepth = 35;
        }
        if (this.hasStonyPeaks && (double)startY > (double)glacierSurfaceHeight + 2.5) {
            NormalSurfaceBuilder.ROCKY.buildSurface(context, startY, endY);
        } else if ((double)startY < (double)glacierBaseHeight - 1.5) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY);
        } else if (this.isShoreBiome && startY <= seaLevel) {
            ShoreAndOceanSurfaceBuilder.MOUNTAINS.apply(this.seed).buildSurface(context, startY, endY);
        } else {
            int surfaceDepth = -1;
            SurfaceState snowState = SurfaceStates.SNOW;
            SurfaceState iceState = SurfaceStates.PACKED_ICE;
            SurfaceState blueIceState = SurfaceStates.BLUE_ICE;
            SurfaceState moraineTopState = SurfaceStates.SNOWY_MORAINE;
            SurfaceState moraineState = SurfaceStates.MORAINE;
            for (int y = startY; y >= glacierBaseHeight - 2; --y) {
                BlockState stateAt = context.getBlockState(y);
                if (stateAt.isAir()) {
                    surfaceDepth = -1;
                    continue;
                }
                if (!context.isDefaultBlock(stateAt)) continue;
                if (surfaceDepth == -1) {
                    int surfaceY = y;
                    surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(surfaceY, -3);
                    if (surfaceDepth <= -1) {
                        if (iceDepth < 1) {
                            context.setBlockState(y, moraineState);
                        } else if (y <= glacierBaseHeight) {
                            iceDepth = 0;
                        } else {
                            context.setBlockState(y, iceState);
                        }
                    } else if (iceDepth == 0 || y <= seaLevel || y < glacierBaseHeight) {
                        context.setBlockState(y, moraineState);
                        iceDepth = 0;
                    } else {
                        context.setBlockState(y, snowState);
                    }
                    surfaceDepth = 1;
                    continue;
                }
                if (iceDepth > 0 && y > glacierBaseHeight) {
                    --iceDepth;
                    context.setBlockState(y, y < glacierSurfaceHeight - 16 ? blueIceState : iceState);
                    continue;
                }
                context.setBlockState(y, y == startY ? moraineTopState : moraineState);
            }
        }
    }
}

