/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class PatternedGroundSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = PatternedGroundSurfaceBuilder::new;
    private final NormalSurfaceBuilder surfaceBuilder = NormalSurfaceBuilder.INSTANCE;
    private final Noise2D edgeNoise;

    public PatternedGroundSurfaceBuilder(Seed seed) {
        this.edgeNoise = BiomeNoise.patternedGround(seed.seed());
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        if (this.edgeNoise.noise(context.pos().getX(), context.pos().getZ()) * context.weight() >= -0.6) {
            this.surfaceBuilder.buildSurface(context, startY, endY);
        } else {
            this.surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.MUD, SurfaceStates.MUD, SurfaceStates.GRAVEL, SurfaceStates.MUD, SurfaceStates.MUD);
        }
    }
}

