/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShieldVolcanoSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SimpleSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ShoreAndOceanSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory NORMAL = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.SHORE_SURFACE, SurfaceStates.SHORE_UNDERLAYER, 6, false, false, NormalSurfaceBuilder.ROCKY.apply(seed));
    public static final SurfaceBuilderFactory SANDY = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.SHORE_SAND, SurfaceStates.SHORE_SANDSTONE, 6, false, false, NormalSurfaceBuilder.ROCKY.apply(seed));
    public static final SurfaceBuilderFactory FORCE_RARE_SAND = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.RARE_SHORE_SAND, SurfaceStates.RARE_SHORE_SANDSTONE, 6, false, false, NormalSurfaceBuilder.ROCKY.apply(seed));
    public static final SurfaceBuilderFactory GRAVELLY = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.GRAVEL, SurfaceStates.RAW, 6, false, false, NormalSurfaceBuilder.ROCKY.apply(seed));
    public static final SurfaceBuilderFactory OCEAN = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.SHORE_SURFACE, SurfaceStates.SHORE_UNDERLAYER, 6, false, false, SimpleSurfaceBuilder.OCEAN_MUD.apply(seed));
    public static final SurfaceBuilderFactory SEA_CLIFFS = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.SHORE_SURFACE, SurfaceStates.SHORE_UNDERLAYER, 2, false, false, NormalSurfaceBuilder.ROCKY.apply(seed));
    public static final SurfaceBuilderFactory OLD_SHIELD_VOLCANO = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.VOLCANIC_SHORE_SAND, SurfaceStates.VOLCANIC_SHORE_SANDSTONE, 6, true, false, ShieldVolcanoSurfaceBuilder.ACTIVE.apply(seed));
    public static final SurfaceBuilderFactory ACTIVE_SHIELD_VOLCANO = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.VOLCANIC_SHORE_SAND, SurfaceStates.VOLCANIC_SHORE_SANDSTONE, 2, false, true, ShieldVolcanoSurfaceBuilder.DORMANT.apply(seed));
    public static final SurfaceBuilderFactory MOUNTAINS = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.GRAVEL, SurfaceStates.RAW, 2, false, false, NormalSurfaceBuilder.ROCKY);
    public static final SurfaceBuilderFactory VOLCANIC_MOUNTAINS = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.GRAVEL, SurfaceStates.RAW, 2, false, false, SimpleSurfaceBuilder.ROCKY_VOLCANIC_SOIL.apply(seed));
    public static final SurfaceBuilderFactory ROCKY_SHORE = seed -> new ShoreAndOceanSurfaceBuilder(seed, SurfaceStates.RAW, SurfaceStates.RAW, 6, false, false, SimpleSurfaceBuilder.ROCKY_SHORE.apply(seed));
    final Seed seed;
    final SurfaceState surface;
    final SurfaceState subsurface;
    final int sandHeight;
    final boolean isShieldVolcano;
    final boolean isActiveShieldVolcano;
    final SurfaceBuilder landBuilder;
    private final NormalNoise icebergPillarNoise;
    private final NormalNoise icebergPillarRoofNoise;
    private final NormalNoise icebergSurfaceNoise;
    private final Noise2D patternedNoise;

    protected ShoreAndOceanSurfaceBuilder(Seed seed, SurfaceState surface, SurfaceState subsurface, int sandHeight, boolean shieldVolcano, boolean activeShieldVolcano, SurfaceBuilder landBuilder) {
        this.seed = seed;
        this.surface = surface;
        this.subsurface = subsurface;
        this.sandHeight = sandHeight;
        this.isShieldVolcano = shieldVolcano;
        this.isActiveShieldVolcano = activeShieldVolcano;
        this.landBuilder = landBuilder;
        RandomSource random = seed.forkStable().fork();
        this.icebergPillarNoise = NormalNoise.create((RandomSource)random, (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-6, 1.0, new double[]{1.0, 1.0, 1.0}));
        this.icebergPillarRoofNoise = NormalNoise.create((RandomSource)random, (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-3, 1.0, new double[0]));
        this.icebergSurfaceNoise = NormalNoise.create((RandomSource)random, (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-6, 1.0, new double[]{1.0, 1.0}));
        this.patternedNoise = BiomeNoise.seaIceNoise(seed.forkStable().next());
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        BlockPos pos = context.pos();
        int x = pos.getX();
        int z = pos.getZ();
        int tideLevel = (int)BiomeNoise.shoreTideLevelNoise(this.seed).noise(x, z);
        int sandHeightAbsolute = tideLevel + this.sandHeight;
        int seaLevel = context.getSeaLevel();
        int oceanFloorY = startY > seaLevel ? startY : context.chunk().getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        if (oceanFloorY < tideLevel - 5) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.OCEAN_MUD, SurfaceStates.OCEAN_MUD, SurfaceStates.OCEAN_MUD, SurfaceStates.OCEAN_MUD, SurfaceStates.OCEAN_MUD);
        } else if (oceanFloorY <= sandHeightAbsolute) {
            if (this.isShieldVolcano) {
                if (this.isActiveShieldVolcano) {
                    this.buildLavaFlowSurface(context, startY, endY, x, z);
                } else {
                    ShieldVolcanoSurfaceBuilder.SHORE.apply(this.seed).buildSurface(context, startY, endY);
                }
            } else {
                NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, this.surface, this.surface, this.subsurface, this.surface, this.surface);
            }
        }
        this.landBuilder.buildSurface(context, startY, endY);
        if (startY <= seaLevel) {
            this.frozenOceanExtension(context, startY, endY, oceanFloorY, seaLevel);
        }
    }

    private void buildLavaFlowSurface(SurfaceBuilderContext context, int startY, int endY, int x, int z) {
        Noise2D smoothNoise = BiomeNoise.lavaFlowMaterial(this.seed.seed());
        double noiseValue = smoothNoise.noise(x, z);
        Noise2D lavaFlows = BiomeNoise.lavaFlow(this.seed.seed());
        double flowValue = lavaFlows.noise(x, z);
        if (flowValue < 0.4) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, this.surface, this.surface, this.subsurface, this.surface, this.surface);
        } else if (flowValue < 0.5) {
            if (noiseValue > 0.0) {
                NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_GRAVEL, this.surface, this.subsurface, this.surface, this.surface);
            } else {
                NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, this.surface, this.surface, this.subsurface, this.surface, this.surface);
            }
        } else if (flowValue < 0.75) {
            if (noiseValue > 0.0) {
                NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_GRAVEL, SurfaceStates.BASALT_GRAVEL, SurfaceStates.BASALT, SurfaceStates.BASALT_GRAVEL, this.surface);
            } else {
                NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_COBBLE, SurfaceStates.BASALT_COBBLE, SurfaceStates.BASALT, SurfaceStates.BASALT_COBBLE, this.surface);
            }
        } else if (noiseValue > -0.6) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT, SurfaceStates.BASALT, SurfaceStates.BASALT, SurfaceStates.BASALT, SurfaceStates.BASALT_COBBLE);
        } else {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.SNOWY_BASALT_COBBLE, SurfaceStates.BASALT_COBBLE, SurfaceStates.BASALT, SurfaceStates.BASALT, SurfaceStates.BASALT_COBBLE);
        }
    }

    private void frozenOceanExtension(SurfaceBuilderContext context, int startY, int endY, int oceanFloorY, int seaLevel) {
        OverworldClimateModel model = OverworldClimateModel.getIfPresent(context.level());
        if (model == null) {
            return;
        }
        int x = context.pos().getX();
        int z = context.pos().getZ();
        float maxAnnualTemperature = model.getAverageMonthlyTemperature(z, seaLevel, context.averageTemperature(), 1.0f, true);
        if (maxAnnualTemperature > 2.0f) {
            return;
        }
        double baseNoise = Math.min(Math.abs(this.icebergSurfaceNoise.getValue((double)x, 0.0, (double)z) * 8.25), this.icebergPillarNoise.getValue((double)x * 1.28, 0.0, (double)z * 1.28) * 15.0);
        if (baseNoise > 1.8) {
            double pillarNoise;
            float depthFactor;
            float temperatureFactor = Mth.clampedMap((float)maxAnnualTemperature, (float)-1.0f, (float)2.0f, (float)1.0f, (float)0.5f);
            double icebergMaxY = (double)(temperatureFactor * (depthFactor = Mth.clampedMap((float)oceanFloorY, (float)(seaLevel - 20), (float)(seaLevel - 6), (float)1.0f, (float)0.0f))) * Math.min(baseNoise * baseNoise * 1.2, Math.ceil((pillarNoise = Math.abs(this.icebergPillarRoofNoise.getValue((double)x * 1.17, 0.0, (double)z * 1.17) * 1.5)) * 30.0) + 11.0);
            if (icebergMaxY < 2.0) {
                this.placeSeaIce(context, x, z, seaLevel, maxAnnualTemperature);
            } else {
                BlockState packedIce = Blocks.PACKED_ICE.defaultBlockState();
                BlockState snow = Blocks.SNOW_BLOCK.defaultBlockState();
                RandomSource random = context.random();
                double icebergMinY = (double)seaLevel - icebergMaxY - 7.0;
                int snowDepth = 2 + random.nextInt(4);
                int snowBoundaryY = seaLevel + 18 + random.nextInt(10);
                int placedSnow = 0;
                for (int y = Math.max(startY, (int)(icebergMaxY += (double)seaLevel) + 1); y >= endY; --y) {
                    BlockState state = context.getBlockState(y);
                    if (!(state.isAir() && (double)y < icebergMaxY && random.nextDouble() > 0.01) && (state.getBlock() != TFCBlocks.SALT_WATER.get() && state.getBlock() != Blocks.WATER || y <= (int)icebergMinY || y >= seaLevel || icebergMinY == 0.0 || !(random.nextDouble() > 0.15))) continue;
                    if (placedSnow <= snowDepth && y > snowBoundaryY) {
                        context.setBlockState(y, snow);
                        ++placedSnow;
                        continue;
                    }
                    context.setBlockState(y, packedIce);
                }
            }
        } else {
            this.placeSeaIce(context, x, z, seaLevel, maxAnnualTemperature);
        }
    }

    private void placeSeaIce(SurfaceBuilderContext context, int x, int z, int seaLevel, float maxAnnualTemperature) {
        int y;
        BlockState state;
        boolean placeIce;
        double iceStart = 1.5;
        double solidIceStart = -0.5;
        BlockState seaIce = ((Block)TFCBlocks.SEA_ICE.get()).defaultBlockState();
        if ((double)maxAnnualTemperature < -0.5) {
            placeIce = true;
        } else if ((double)maxAnnualTemperature > 1.5) {
            placeIce = false;
        } else {
            double tempFactor = Mth.clampedMap((double)maxAnnualTemperature, (double)1.5, (double)-0.5, (double)0.3, (double)0.04);
            boolean bl = placeIce = this.patternedNoise.noise(x, z) > tempFactor;
        }
        if (placeIce && ((state = context.getBlockState(y = seaLevel - 1)).getBlock() == TFCBlocks.SALT_WATER.get() || state.getBlock() == Blocks.WATER)) {
            context.setBlockState(y, seaIce);
        }
    }
}

