/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class StoneCirclesSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = StoneCirclesSurfaceBuilder::new;
    private final NormalSurfaceBuilder surfaceBuilder = NormalSurfaceBuilder.ROCKY;
    private final Noise2D edgeNoise;

    public StoneCirclesSurfaceBuilder(Seed seed) {
        this.edgeNoise = BiomeNoise.stoneCircles(seed.seed());
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        if (this.edgeNoise.noise(context.pos().getX(), context.pos().getZ()) * context.weight() <= 0.6) {
            this.surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.SNOWY_SAND_AND_GRAVEL, SurfaceStates.SAND_AND_GRAVEL, SurfaceStates.GRAVEL);
        } else {
            this.surfaceBuilder.buildSurface(context, startY, endY, SurfaceStates.SNOWY_COBBLE, SurfaceStates.MORAINE, SurfaceStates.GRAVEL);
        }
    }
}

