/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VolcanoesSurfaceBuilder
implements SurfaceBuilder {
    private final SurfaceBuilder parent;
    private final Noise2D heightNoise;
    private final VolcanoNoise volcanoNoise;

    public static SurfaceBuilderFactory create(SurfaceBuilderFactory parent) {
        return seed -> new VolcanoesSurfaceBuilder(parent.apply(seed), seed);
    }

    public VolcanoesSurfaceBuilder(SurfaceBuilder parent, Seed seed) {
        this.parent = parent;
        this.volcanoNoise = new VolcanoNoise(seed);
        this.heightNoise = new OpenSimplex2D(seed.next()).octaves(2).spread(0.1f).scaled(-4.0, 4.0);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        float easing;
        if (context.biome().isVolcanic() && (easing = this.volcanoNoise.calculateEasing(context.pos(), context.biome())) > 0.6f && (double)startY > (double)context.biome().getVolcanoBasaltHeight() + this.heightNoise.noise(context.pos().getX(), context.pos().getZ())) {
            this.buildVolcanicSurface(context, startY, endY, easing);
            return;
        }
        this.parent.buildSurface(context, startY, endY);
    }

    private void buildVolcanicSurface(SurfaceBuilderContext context, int startY, int endY, float easing) {
        BlockState basalt = ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.RAW).get()).defaultBlockState();
        int surfaceDepth = -1;
        for (int y = startY; y >= endY; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.isAir()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                surfaceDepth = context.calculateAltitudeSlopeSurfaceDepth(y, 4);
                surfaceDepth = Mth.clamp((int)((int)((float)surfaceDepth * (easing - 0.6f) / 0.4f)), (int)2, (int)11);
                context.setBlockState(y, basalt);
                continue;
            }
            if (surfaceDepth <= 0) continue;
            --surfaceDepth;
            context.setBlockState(y, basalt);
        }
    }
}

